// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM value-map-builder.ts >>>

package com.yandex.xplat.eventus.common

import com.yandex.xplat.common.*

public open class ValueMapBuilder private constructor(map: YSMap<String, JSONItem> = mutableMapOf<String, JSONItem>()) {
    private val map: YSMap<String, JSONItem> = mutableMapOf<String, JSONItem>()
    init {
        map.__forEach( {
            v, k ->
            this.map.set(k, v)
        })
    }
    open fun __plus(more: ValueMapBuilder): ValueMapBuilder {
        val result = mutableMapOf<String, JSONItem>()
        this.map.__forEach( {
            v, k ->
            result.set(k, v)
        })
        more.map.__forEach( {
            v, k ->
            result.set(k, v)
        })
        return ValueMapBuilder(result)
    }

    open fun setEventName(name: String): ValueMapBuilder {
        return this.setString(EventAttribute.EventName, name)
    }

    open fun addEventusId(eventusId: Long): ValueMapBuilder {
        return this.setInt64(EventusConstants.EVENTUS_ID, eventusId)
    }

    open fun addOriginEventusId(eventusId: Long): ValueMapBuilder {
        return this.setInt64(EventusConstants.ORIGIN_EVENTUS_ID, eventusId)
    }

    open fun addStartEvent(): ValueMapBuilder {
        return this.setBoolean(EventAttribute.StartEvent, true)
    }

    open fun addTimespan(value: Long): ValueMapBuilder {
        return this.setInt64(EventAttribute.Timespan, value)
    }

    open fun addOrder(order: Int): ValueMapBuilder {
        return this.setInt32(EventAttribute.Order, order)
    }

    open fun addCount(count: Int): ValueMapBuilder {
        return this.setInt32(EventAttribute.Count, count)
    }

    open fun addRepliesNumber(repliesNumber: Int?): ValueMapBuilder {
        if (repliesNumber != null) {
            return this.setInt32(EventAttribute.RepliesNumber, repliesNumber)
        }
        return this
    }

    open fun addRepliesNumbers(repliesNumbers: YSArray<Int>?): ValueMapBuilder {
        if (repliesNumbers != null) {
            return this.setInt32Array(EventAttribute.RepliesNumbers, repliesNumbers)
        }
        return this
    }

    open fun addLength(length: Int?): ValueMapBuilder {
        if (length != null) {
            return this.setInt32(EventAttribute.Length, length)
        }
        return this
    }

    open fun addUid(uid: Long?): ValueMapBuilder {
        if (uid != null) {
            return this.setInt64(EventAttribute.Uid, uid)
        }
        return this
    }

    open fun addMid(mid: Long?): ValueMapBuilder {
        if (mid != null) {
            return this.setInt64(EventAttribute.Mid, mid)
        }
        return this
    }

    open fun addMids(mids: YSArray<Long>?): ValueMapBuilder {
        if (mids != null) {
            return this.setInt64Array(EventAttribute.Mids, mids)
        }
        return this
    }

    open fun addFid(fid: Long): ValueMapBuilder {
        return this.setInt64(EventAttribute.Fid, fid)
    }

    open fun addTid(tid: Long): ValueMapBuilder {
        return this.setInt64(EventAttribute.Tid, tid)
    }

    open fun addStoryId(storyId: StoryId): ValueMapBuilder {
        return this.setString(EventAttribute.StoryId, storyId)
    }

    open fun addBlanksNumber(blanksNumbers: Int): ValueMapBuilder {
        return this.setInt32(EventAttribute.BlanksNumber, blanksNumbers)
    }

    open fun addSharedState(shared: Boolean): ValueMapBuilder {
        return this.setBoolean(EventAttribute.Shared, shared)
    }

    open fun addService(service: EcomailService): ValueMapBuilder {
        return this.setString(EventAttribute.Service, service.toString())
    }

    open fun addSource(source: String): ValueMapBuilder {
        return this.setString(EventAttribute.Source, source)
    }

    open fun addContactField(contactField: ContactField): ValueMapBuilder {
        return this.setString(EventAttribute.Field, contactField.toString())
    }

    open fun addStatus(status: String): ValueMapBuilder {
        return this.setString(EventAttribute.Status, status)
    }

    open fun addFields(fields: YSArray<String>?): ValueMapBuilder {
        if (fields != null) {
            return this.setStringArray(EventAttribute.Fields, fields)
        }
        return this
    }

    open fun addMessages(messages: YSArray<MessageDTO>?): ValueMapBuilder {
        if (messages != null) {
            val array = ArrayJSONItem()
            for (message in messages) {
                array.add(message.toJson())
            }
            this.map.set(EventAttribute.Messages, array)
        }
        return this
    }

    open fun addDebug(): ValueMapBuilder {
        return this.setBoolean(EventAttribute.Debug, true)
    }

    open fun addError(): ValueMapBuilder {
        return this.setBoolean(EventAttribute.Error, true)
    }

    open fun addReason(reason: String?): ValueMapBuilder {
        if (reason != null) {
            this.setString(EventAttribute.Reason, reason)
        }
        return this
    }

    open fun addSuggestType(suggestType: String): ValueMapBuilder {
        return this.setString(EventAttribute.SuggestType, suggestType)
    }

    open fun addSuggestValue(suggestValue: String): ValueMapBuilder {
        return this.setString(EventAttribute.SuggestValue, suggestValue)
    }

    open fun addSuggestPosition(suggestPosition: Int): ValueMapBuilder {
        return this.setInt32(EventAttribute.SuggestPosition, suggestPosition)
    }

    open fun addEvent(event: String): ValueMapBuilder {
        return this.setString(EventAttribute.Event, event)
    }

    open fun addSaveDraft(saveDraft: Boolean): ValueMapBuilder {
        return this.setBoolean(EventAttribute.SaveDraft, saveDraft)
    }

    open fun build(): YSMap<String, JSONItem> {
        return this.map
    }

    private fun setBoolean(name: String, value: Boolean): ValueMapBuilder {
        this.map.set(name, BooleanJSONItem(value))
        return this
    }

    private fun setInt32(name: String, value: Int): ValueMapBuilder {
        this.map.set(name, IntegerJSONItem.fromInt32(value))
        return this
    }

    private fun setInt64(name: String, value: Long): ValueMapBuilder {
        this.map.set(name, IntegerJSONItem.fromInt64(value))
        return this
    }

    private fun setString(name: String, value: String): ValueMapBuilder {
        this.map.set(name, StringJSONItem(value))
        return this
    }

    private fun setInt32Array(name: String, value: YSArray<Int>): ValueMapBuilder {
        this.map.set(name, ArrayJSONItem(value.map( {
            n ->
            IntegerJSONItem.fromInt32(n)
        })))
        return this
    }

    private fun setInt64Array(name: String, value: YSArray<Long>): ValueMapBuilder {
        this.map.set(name, ArrayJSONItem(value.map( {
            n ->
            IntegerJSONItem.fromInt64(n)
        })))
        return this
    }

    private fun setStringArray(name: String, value: YSArray<String>): ValueMapBuilder {
        this.map.set(name, ArrayJSONItem(value.map( {
            s ->
            StringJSONItem(s)
        })))
        return this
    }

    companion object {
        @JvmStatic
        open fun userEvent(): ValueMapBuilder {
            return ValueMapBuilder().setString(EventAttribute.EventType, "user")
        }

        @JvmStatic
        open fun systemEvent(): ValueMapBuilder {
            return ValueMapBuilder().setString(EventAttribute.EventType, "system")
        }

        @JvmStatic
        open fun modelSyncEvent(): ValueMapBuilder {
            return ValueMapBuilder().setString(EventAttribute.EventType, "model_sync")
        }

        @JvmStatic
        open fun customEvent(source: String, map: YSMap<String, JSONItem> = mutableMapOf<String, JSONItem>()): ValueMapBuilder {
            return ValueMapBuilder(map).setString(EventAttribute.EventType, "other").setString(EventAttribute.EventSource, source)
        }

        @JvmStatic
        open fun __parse(map: YSMap<String, JSONItem>): ValueMapBuilder {
            return ValueMapBuilder(map)
        }

    }
}

