// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM events/contact-events.ts >>>

package com.yandex.xplat.eventus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.eventus.common.ContactField
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.eventus.common.ValueMapBuilder

public open class ContactEvents {
    open fun openContactList(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_LIST_OPEN, ValueMapBuilder.userEvent())
    }

    open fun closeContactList(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_LIST_CLOSE, ValueMapBuilder.userEvent())
    }

    open fun clickContactList(source: String): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_LIST_CLICK, ValueMapBuilder.userEvent().addSource(source))
    }

    open fun changeContactListMode(shared: Boolean): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_LIST_MODE_CHANGE, ValueMapBuilder.userEvent().addSharedState(shared))
    }

    open fun createContact(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_LIST_CREATE, ValueMapBuilder.userEvent())
    }

    open fun searchContact(length: Int): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_LIST_SEARCH, ValueMapBuilder.userEvent().addLength(length))
    }

    open fun openContactCreate(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_CREATE_OPEN, ValueMapBuilder.userEvent())
    }

    open fun submitContactCreate(status: String, fields: YSArray<String>?): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_CREATE_SUBMIT, ValueMapBuilder.userEvent().addStatus(status).addFields(fields))
    }

    open fun closeContactCreate(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_CREATE_CLOSE, ValueMapBuilder.userEvent())
    }

    open fun openContactDetails(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_DETAILS_OPEN, ValueMapBuilder.userEvent())
    }

    open fun initContactDetails(source: String): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_DETAILS_INIT, ValueMapBuilder.userEvent().addSource(source))
    }

    open fun clickContactDetails(`field`: ContactField): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_DETAILS_CLICK, ValueMapBuilder.userEvent().addContactField(`field`))
    }

    open fun copyContactDetails(`field`: ContactField): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_DETAILS_COPY, ValueMapBuilder.userEvent().addContactField(`field`))
    }

    open fun editContactDetails(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_DETAILS_EDIT, ValueMapBuilder.userEvent())
    }

    open fun deleteContactDetails(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_DETAILS_DELETE, ValueMapBuilder.userEvent())
    }

    open fun closeContactDetails(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_DETAILS_CLOSE, ValueMapBuilder.userEvent())
    }

    open fun openContactEdit(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_EDIT_OPEN, ValueMapBuilder.userEvent())
    }

    open fun submitContactEdit(status: String, fields: YSArray<String>?): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_EDIT_SUBMIT, ValueMapBuilder.userEvent().addStatus(status).addFields(fields))
    }

    open fun closeContactEdit(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.CONTACT_EDIT_CLOSE, ValueMapBuilder.userEvent())
    }

}

