// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM events/message-list-events.ts >>>

package com.yandex.xplat.eventus

import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.eventus.common.ValueMapBuilder

public open class MessageListEvents {
    open fun openMessage(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_OPEN, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_OPEN, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun deleteMessage(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_DELETE, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_DELETE, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun openMessageActions(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_OPEN_ACTIONS, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_OPEN_ACTIONS, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun refreshMessageList(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_REFRESH, ValueMapBuilder.userEvent())
    }

    open fun writeNewMessage(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_WRITE_NEW_MESSAGE, ValueMapBuilder.userEvent())
    }

    open fun markMessageAsRead(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_MARK_AS_READ, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_MARK_AS_READ, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun markMessageAsUnread(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_MARK_AS_UNREAD, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_MARK_AS_UNREAD, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun toggleMarkMessageAsRead(read: Boolean, order: Int, mid: Long): EventusEvent {
        return if (read) this.markMessageAsRead(order, mid) else this.markMessageAsUnread(order, mid)
    }

    open fun replyMessage(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_REPLY, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_REPLY, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun replyAllMessage(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_REPLY_ALL, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_REPLY_ALL, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun forwardMessage(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_FORWARD, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_FORWARD, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun markMessageAsNotImportant(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_MARK_AS_NOT_IMPORTANT, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_MARK_AS_NOT_IMPORTANT, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun markMessageAsImportant(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_MARK_AS_IMPORTANT, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_MARK_AS_IMPORTANT, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun markMessageAsSpam(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_MARK_AS_SPAM, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_MARK_AS_SPAM, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun markMessageAsNotSpam(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_MARK_AS_NOT_SPAM, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_MARK_AS_NOT_SPAM, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun moveMessageToFolder(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_MOVE_TO_FOLDER, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_MOVE_TO_FOLDER, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun markMessageAs(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_MARK_AS, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_MARK_AS, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun archiveMessage(order: Int, mid: Long): EventusEvent {
        if (order < 0) {
            return EventusEvent.eventCreationErrorEvent(EventNames.LIST_MESSAGE_ARCHIVE, "Order must be equal or greater then 0. Was: ${order}")
        }
        return EventusEvent.newClientEvent(EventNames.LIST_MESSAGE_ARCHIVE, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

}

