// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM events/quick-reply-events.ts >>>

package com.yandex.xplat.eventus

import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.eventus.common.ValueMapBuilder

public open class QuickReplyEvents {
    open fun clicked(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.QUICK_REPLY_CLICKED, ValueMapBuilder.userEvent())
    }

    open fun smartReplyMessageClicked(order: Int): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.QUICK_REPLY_SMART_REPLY_MESSAGE_CLICKED, ValueMapBuilder.userEvent().addOrder(order))
    }

    open fun openCompose(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.QUICK_REPLY_OPEN_COMPOSE, ValueMapBuilder.userEvent())
    }

    open fun smartReplyShown(repliesNumber: Int): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.QUICK_REPLY_SMART_REPLY_SHOWN, ValueMapBuilder.systemEvent().addRepliesNumber(repliesNumber))
    }

    open fun editBody(length: Int? = null): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.QUICK_REPLY_EDIT_BODY, ValueMapBuilder.userEvent().addLength(length))
    }

    open fun closeSmartReplyMessage(order: Int, mid: Long): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.QUICK_REPLY_CLOSE_SMART_REPLY_MESSAGE, ValueMapBuilder.userEvent().addOrder(order).addMid(mid))
    }

    open fun closeAllSmartReplies(mid: Long): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.QUICK_REPLY_CLOSE_ALL_SMART_REPLIES, ValueMapBuilder.userEvent().addMid(mid))
    }

    open fun sendMessage(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.QUICK_REPLY_SEND_MESSAGE, ValueMapBuilder.userEvent())
    }

    open fun smartRepliesTurnedByUser(newState: Boolean): EventusEvent {
        return EventusEvent.newClientEvent(if (newState) EventNames.SMART_REPLY_TURNED_ON_BY_USER else EventNames.SMART_REPLY_TURNED_OFF_BY_USER)
    }

}

