// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM events/stories-events.ts >>>

package com.yandex.xplat.eventus

import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.eventus.common.StoryId
import com.yandex.xplat.eventus.common.ValueMapBuilder

public open class StoriesEvents {
    open fun closeClicked(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.STORIES_CLOSE_CLICK, ValueMapBuilder.userEvent())
    }

    open fun storiesShown(): EventusEvent {
        return EventusEvent.newClientEvent(EventNames.STORIES_SHOWN, ValueMapBuilder.systemEvent())
    }

    open fun storyOpen(storyId: StoryId, order: Int): EventusEvent {
        val mapBuilder = ValueMapBuilder.userEvent().addOrder(order).addStoryId(storyId)
        return EventusEvent.newClientEvent(EventNames.STORY_OPEN, mapBuilder)
    }

    open fun storyActionClick(storyId: StoryId, slidePosition: Int): EventusEvent {
        val mapBuilder = ValueMapBuilder.userEvent().addOrder(slidePosition).addStoryId(storyId)
        return EventusEvent.newClientEvent(EventNames.STORY_ACTION_CLICK, mapBuilder)
    }

    open fun storySlideShown(storyId: StoryId, slidePosition: Int): EventusEvent {
        val mapBuilder = ValueMapBuilder.userEvent().addOrder(slidePosition).addStoryId(storyId)
        return EventusEvent.newClientEvent(EventNames.STORY_SLIDE_SHOWN, mapBuilder)
    }

    open fun storyNextSlide(storyId: StoryId, slidePosition: Int): EventusEvent {
        val mapBuilder = ValueMapBuilder.userEvent().addOrder(slidePosition).addStoryId(storyId)
        return EventusEvent.newClientEvent(EventNames.STORY_SLIDE_NEXT_CLICK, mapBuilder)
    }

    open fun storyPreviousSlide(storyId: StoryId, slidePosition: Int): EventusEvent {
        val mapBuilder = ValueMapBuilder.userEvent().addOrder(slidePosition).addStoryId(storyId)
        return EventusEvent.newClientEvent(EventNames.STORY_SLIDE_PREVIOUS_CLICK, mapBuilder)
    }

    open fun storySlidePause(storyId: StoryId, slidePosition: Int): EventusEvent {
        val mapBuilder = ValueMapBuilder.userEvent().addOrder(slidePosition).addStoryId(storyId)
        return EventusEvent.newClientEvent(EventNames.STORY_SLIDE_PAUSE, mapBuilder)
    }

    open fun storySlideResume(storyId: StoryId, slidePosition: Int): EventusEvent {
        val mapBuilder = ValueMapBuilder.userEvent().addOrder(slidePosition).addStoryId(storyId)
        return EventusEvent.newClientEvent(EventNames.STORY_SLIDE_RESUME, mapBuilder)
    }

}

