// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/mail-api-error.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class MailApiError(message: String): YSError(message) {
    companion object {
        @JvmStatic
        open fun checkStatus(status: NetworkStatus): Result<Unit> {
            val statusCode = status.code
            if (statusCode == NetworkStatusCode.ok) {
                return Result<Unit>(getVoid(), null)
            }
            if (MailApiAuthError.isAuthError(status)) {
                return Result<Unit>(null, MailApiAuthError(status))
            }
            when (statusCode) {
                NetworkStatusCode.permanentError -> {
                    return Result<Unit>(null, MailApiPermError(status))
                }
                NetworkStatusCode.temporaryError -> {
                    return Result<Unit>(null, MailApiTempError(status))
                }
                else -> {
                    return Result<Unit>(null, MailApiError("Unsupported type of status: ${status.getErrorMessage()}"))
                }
            }
        }

        @JvmStatic
        open fun checkStatusAsync(status: NetworkStatus): XPromise<Unit> {
            val result = this.checkStatus(status)
            return if (result.isValue()) resolve(result.getValue()) else reject(result.getError() as YSError)
        }

        @JvmStatic
        open fun <T: ResponseWithStatus> checkResponseWithStatus(response: T): XPromise<T> {
            return this.checkStatusAsync(response.networkStatus()).then( {
                _ ->
                response
            })
        }

    }
}

public open class BadStatusError(val status: NetworkStatus): YSError(status.getErrorMessage()) {
}

public open class MailApiPermError(status: NetworkStatus): BadStatusError(status) {
}

public open class MailApiTempError(status: NetworkStatus): BadStatusError(status) {
}

public open class MailApiAuthError(status: NetworkStatus): BadStatusError(status) {
    companion object {
        @JvmStatic private var AUTH_ERROR_PREFIX: String = "200"
        @JvmStatic
        open fun isAuthError(status: NetworkStatus): Boolean {
            if (status.code == NetworkStatusCode.authenticationError) {
                return true
            }
            if (status.code != NetworkStatusCode.permanentError || status.phrase == null) {
                return false
            }
            for (error in status.phrase.split(",")) {
                val tokens = error.split(":")
                if (tokens.size <= 1) {
                    continue
                }
                val token = tokens[tokens.size - 1]
                if (token.trim().startsWith(MailApiAuthError.AUTH_ERROR_PREFIX)) {
                    return true
                }
            }
            return false
        }

    }
}

