// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/actions/set-parameters-request.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class SetParametersRequest(private val parameters: SetParametersItems): MailNetworkRequest() {
    open override fun version(): NetworkAPIVersions {
        return NetworkAPIVersions.v1
    }

    open override fun method(): NetworkMethod {
        return NetworkMethod.post
    }

    open override fun path(): String {
        return "set_parameters"
    }

    open override fun params(): NetworkParams {
        return MapJSONItem().putString("params", this.serializeParameters())
    }

    open override fun encoding(): RequestEncoding {
        return JsonRequestEncoding()
    }

    private fun serializeParameters(): String {
        return this.parameters.items.map( {
            item ->
            "${item.key}=${item.value}"
        }).joinToString(":")
    }

}

public open class SetParametersItems(items: YSArray<SetParametersItem>) {
    val items: YSArray<SetParametersItem>
    init {
        val result: YSArray<SetParametersItem> = mutableListOf()
        val existing = YSSet<String>()
        for (item in items) {
            if (!existing.has(item.key)) {
                existing.add(item.key)
                result.add(item)
            }
        }
        this.items = result
    }
    open fun toJSONItem(): JSONItem {
        return this.items.reduce( {
            res, item ->
            res.putString(item.key, item.value)
        }
, MapJSONItem())
    }

    companion object {
        @JvmStatic
        open fun fromJSONItem(jsonItem: JSONItem): SetParametersItems? {
            if (jsonItem.kind != JSONItemKind.map) {
                return null
            }
            val paramsMap = jsonItem as MapJSONItem
            val resultArray: YSArray<SetParametersItem> = mutableListOf()
            paramsMap.asMap().__forEach(__LBL__SetParametersRequest_1@ {
                v, k ->
                if (v.kind == JSONItemKind.string) {
                    resultArray.add(SetParametersItem(k, (v as StringJSONItem).value))
                }
            })
            return SetParametersItems(resultArray)
        }

    }
}

public open class SetParametersItem(val key: String, val value: String) {
    companion object {
        @JvmStatic
        open fun createOpenFromWeb(value: Boolean): SetParametersItem {
            return SetParametersItem("mobile_open_from_web", if (value) "1" else "0")
        }

        @JvmStatic
        open fun createShowFolderTabs(value: Boolean): SetParametersItem {
            return SetParametersItem("show_folders_tabs", if (value) "on" else "")
        }

    }
}

