// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/avatars/avatar.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem

public enum class AvaType(val value: String) {
    avatar("avatar"),
    icon("icon"),
    none("none"),
    unknown("unknown"),
    ;
    override fun toString(): String = value
}
public fun avaTypeFromServerValue(value: String): AvaType {
    when (value) {
        "avatar" -> {
            return AvaType.avatar
        }
        "icon" -> {
            return AvaType.icon
        }
        "none" -> {
            return AvaType.none
        }
        else -> {
            return AvaType.unknown
        }
    }
}

public fun avaTypeToInt32(avaType: AvaType): Int? {
    when (avaType) {
        AvaType.avatar -> {
            return 0
        }
        AvaType.icon -> {
            return 1
        }
        AvaType.none -> {
            return 2
        }
        AvaType.unknown -> {
            return 3
        }
    }
}

public fun avaTypeFromInt32(value: Int): AvaType {
    when (value) {
        0 -> {
            return AvaType.avatar
        }
        1 -> {
            return AvaType.icon
        }
        2 -> {
            return AvaType.none
        }
        3 -> {
            return AvaType.unknown
        }
        else -> {
            return AvaType.unknown
        }
    }
}

public open class Ava(val type: AvaType, val url: String) {
}

public open class Avatar(val local: String?, val domain: String?, val email: String, val displayName: String?, val mono: String?, val color: String?, val ava: Ava?, val valid: Boolean, val parsed: Boolean) {
}

public fun avatarFromJSONItem(item: JSONItem, forEmail: String): Avatar? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val valid = map.getBooleanOrDefault("valid", false)
    if (!valid) {
        return null
    }
    val local = map.getString("local")
    val domain = map.getString("domain")
    val email = forEmail
    val displayName = map.getString("display_name")
    val mono = map.getString("mono")
    val color = map.getString("color")
    val ava = avaFromJSONItem(map.`get`("ava"))
    return Avatar(local, domain, email, displayName, mono, color, ava, valid, true)
}

private fun avaFromJSONItem(item: JSONItem?): Ava? {
    if (item == null || item!!.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val type = avaTypeFromServerValue(map.getString("type")!!)
    val url = map.getString("url_mobile")!!
    return Ava(type, url)
}

