// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/avatars/avatar-response.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class AvatarResponse(val status: NetworkStatus, val payload: YSMap<String, YSArray<Avatar>>): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.status
    }

}

public fun avatarResponseFromJSONItem(item: JSONItem): AvatarResponse? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val statusObject = map.`get`("status")
    if (statusObject == null) {
        return null
    }
    val status = networkStatusFromJSONItem(statusObject!!)
    if (status == null || status!!.code != NetworkStatusCode.ok) {
        return AvatarResponse(if (status == null) NetworkStatus(NetworkStatusCode.temporaryError) else status, mutableMapOf<String, YSArray<Avatar>>())
    }
    val catdogObject = map.`get`("catdog")
    if (catdogObject == null || catdogObject!!.kind != JSONItemKind.map) {
        return AvatarResponse(status!!, mutableMapOf<String, YSArray<Avatar>>())
    }
    val catdog = catdogObject as MapJSONItem
    val payload = mutableMapOf<String, YSArray<Avatar>>()
    catdog.asMap().__forEach(__LBL__AvatarResponse_1@ {
        items, email ->
        if (items.kind == JSONItemKind.array) {
            val resultingAvatars: YSArray<Avatar> = mutableListOf()
            for (avatarObject in (items as ArrayJSONItem).asArray()) {
                val avatar = avatarFromJSONItem(avatarObject, email)
                if (avatar != null) {
                    resultingAvatars.add(avatar!!)
                }
            }
            payload.set(email, resultingAvatars)
        }
    })
    return AvatarResponse(status, payload)
}

