// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/body/message-body.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class MessageBody(val status: NetworkStatus, val payload: MessageBodyPayload?) {
}

public open class MessageBodyPayload(val info: MessageBodyInfo, val body: YSArray<MessageBodyPart>, val contentType: String, val lang: String) {
}

public open class MessageBodyInfo(val mid: ID, val attachments: YSArray<MessageBodyAttach>, val recipients: YSArray<Recipient>, val rfcId: String, val references: String) {
}

public open class MessageBodyPart(val hid: String, val content: String?, val contentType: String, val lang: String) {
}

public open class MessageBodyAttach(val hid: String, val displayName: String, val size: Long?, val downloadUrl: String, val isDisk: Boolean, val previewSupported: Boolean, val isInline: Boolean, val attachClass: String?, val mimeType: String, val contentId: String?) {
}

public open class MessageBodyDescriptor(val mid: ID, val sourceLang: String?, val targetLang: String?) {
    open fun isTranslated(): Boolean {
        return this.sourceLang != null && this.targetLang != null
    }

    companion object {
        @JvmStatic val KEY_DIVIDER: String = "^^"
        @JvmStatic
        open fun fromKey(key: String): MessageBodyDescriptor? {
            val parts = key.split(MessageBodyDescriptor.KEY_DIVIDER)
            if (parts.size == 1) {
                return MessageBodyDescriptor(idFromString(parts[0])!!, null, null)
            } else if (parts.size == 3) {
                return MessageBodyDescriptor(idFromString(parts[0])!!, parts[1], parts[2])
            }
            return null
        }

    }
}

public typealias MessageBodyResponse = YSArray<MessageBody>

public fun messageBodyResponseFromJSONItem(item: JSONItem): MessageBodyResponse? {
    if (item.kind != JSONItemKind.array) {
        return null
    }
    val array = item as ArrayJSONItem
    return array.asArray().map( {
        `val` ->
        messageBodyFromJSONItem(`val`)!!
    })
}

public fun messageBodyInfoFromJSONItem(item: JSONItem): MessageBodyInfo? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val mid = idFromString(map.getString("mid"))!!
    val attachments = map.getArrayOrDefault("attachments", mutableListOf()).map( {
        i ->
        messageBodyAttachFromJSONItem(i)!!
    })
    val recipients = map.getArrayOrDefault("recipients", mutableListOf()).map( {
        i ->
        recipientFromJSONItem(i)!!
    })
    val rfcId = map.getStringOrDefault("ext_msg_id", "")
    val references = map.getStringOrDefault("references", "")
    return MessageBodyInfo(mid, attachments, recipients, rfcId, references)
}

public fun messageBodyPartFromJSONItem(item: JSONItem): MessageBodyPart? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val hid = map.getString("hid")!!
    val content = map.getString("content")
    val contentType = map.getString("content_type")!!
    val lang = map.getString("lang")!!
    return MessageBodyPart(hid, content, contentType, lang)
}

public fun messageBodyAttachFromJSONItem(item: JSONItem): MessageBodyAttach? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val hid = map.getString("hid")!!
    val displayName = map.getString("display_name")!!
    val size = map.getInt64OrDefault("size", int64(0))
    val downloadUrl = map.getString("download_url")!!
    val isDisk = map.getBooleanOrDefault("narod", false)
    val previewSupported = map.getBooleanOrDefault("preview_supported", false)
    val isInline = map.getBooleanOrDefault("is_inline", false)
    val attachClass = map.getString("class")
    val mimeType = map.getString("mime_type")!!
    val contentId = map.getString("content_id")
    return MessageBodyAttach(hid, displayName, size, downloadUrl, isDisk, previewSupported, isInline, attachClass, mimeType, contentId)
}

public fun messageBodyFromJSONItem(item: JSONItem): MessageBody? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val status = networkStatusFromJSONItem(map.`get`("status")!!)!!
    if (status.code != NetworkStatusCode.ok) {
        return MessageBody(status, null)
    }
    val info = messageBodyInfoFromJSONItem(map.`get`("info")!!)!!
    val body = map.getArrayOrDefault("body", mutableListOf()).map( {
        i ->
        messageBodyPartFromJSONItem(i)!!
    })
    var contentType = "text/html"
    var lang = ""
    if (body.size > 0) {
        contentType = body[body.size - 1].contentType
        lang = body[body.size - 1].lang
    }
    return MessageBody(status, MessageBodyPayload(info, body, contentType, lang))
}

