// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/contact/contact.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem

public open class Contact(val name: String, val email: String) {
}

public fun contactFromJSONItem(item: JSONItem): Contact? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val name = map.getString("name")!!
    val email = map.getString("email")!!
    return Contact(name, email)
}

public fun contactFromABookTopJSONItem(item: JSONItem): Contact? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val name = map.`get`("name")
    if (name == null || name.kind != JSONItemKind.map) {
        return null
    }
    val fullName = (name as MapJSONItem).getString("full")
    val email = map.getString("email")
    if (fullName == null || email == null) {
        return null
    }
    return Contact(fullName!!, email!!)
}

public fun contactToJSONItem(contact: Contact): JSONItem {
    return MapJSONItem().putString("name", contact.name).putString("email", contact.email)
}

