// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/contact/contact-response.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class ContactResponse(val status: NetworkStatus, val contacts: YSArray<Contact>): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.status
    }

}

public fun contactResponseFromJSONItem(item: JSONItem): ContactResponse? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val statusObject = map.`get`("status")
    if (statusObject == null) {
        return null
    }
    val status = networkStatusFromJSONItem(statusObject)!!
    if (status.code != NetworkStatusCode.ok) {
        return ContactResponse(status, mutableListOf())
    }
    val contactItem = map.`get`("contacts")!!
    if (contactItem.kind != JSONItemKind.map) {
        return null
    }
    val contactsMap = contactItem as MapJSONItem
    val contactsJson = contactsMap.`get`("contacts")!!
    val contacts = if (contactsJson.kind == JSONItemKind.array) contactsFromJSONItem(contactsJson as ArrayJSONItem) else mutableListOf()
    return ContactResponse(status, contacts)
}

public fun contactsFromJSONItem(items: ArrayJSONItem): YSArray<Contact> {
    val result: YSArray<Contact> = mutableListOf()
    for (item in items.asArray()) {
        val contact = contactFromJSONItem(item as MapJSONItem)
        if (contact != null) {
            result.add(contact)
        }
    }
    return result
}

