// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/container/container.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class Container(val stats: ContainerStats, val folders: YSArray<Folder>, val labels: YSArray<Label>): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.stats.status
    }

}

public fun containerFromJSONItem(item: JSONItem): Container? {
    if (item.kind != JSONItemKind.array) {
        return null
    }
    val array = item as ArrayJSONItem
    val containerStats = containerStatsFromJSONItem(array.`get`(0))
    if (containerStats == null) {
        return null
    }
    val folders: YSArray<Folder> = mutableListOf()
    val labels: YSArray<Label> = mutableListOf()
    if (containerStats.status.code == NetworkStatusCode.ok) {
        for (value in array.asArray()) {
            val map = value as MapJSONItem
            if (map.hasKey("fid")) {
                folders.add(folderFromJSONItem(map)!!)
            } else if (map.hasKey("lid")) {
                labels.add(labelFromJSONItem(map)!!)
            }
        }
    }
    return Container(containerStats, folders, labels)
}

