// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/container/container-stats.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem

public open class ContainerStatsPayload(val md5: String, val mailboxRevision: Int) {
}

public open class ContainerStats(val status: NetworkStatus, val payload: ContainerStatsPayload?) {
}

public fun containerStatsFromJSONItem(item: JSONItem): ContainerStats? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val status = networkStatusFromJSONItem(map.`get`("status")!!)!!
    if (status.code != NetworkStatusCode.ok) {
        return ContainerStats(status, null)
    }
    val md5 = map.getString("md5")!!
    val mailboxRevision = map.getInt32("mailbox_revision")!!
    return ContainerStats(status, ContainerStatsPayload(md5, mailboxRevision))
}

