// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/delta-api/entities/delta-api-envelope.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class DeltaApiAttachment(val hid: String, val contentType: String, val fileName: String, val size: Int) {
}

public open class DeltaApiRecipient(val local: String, val domain: String, val displayName: String) {
    open fun asString(): String {
        val result = StringBuilder()
        val hasName = this.displayName.length > 0
        if (hasName) {
            result.add(quote(this.displayName))
        }
        if (this.local.length > 0 && this.domain.length > 0) {
            result.add(if (hasName) " " else "").add("<${this.local}@${this.domain}>")
        }
        return result.build()
    }

}

public open class DeltaApiSubject(val type: String, val prefix: String, val subject: String, val postfix: String, val isSplitted: Boolean) {
}

public fun isDeltaApiSubjectEmpty(subjectInfo: DeltaApiSubject?): Boolean {
    return (subjectInfo == null || subjectInfo!!.subject == "No subject" || subjectInfo!!.postfix.length + subjectInfo!!.prefix.length + subjectInfo!!.subject.length == 0)
}

public open class DeltaApiEnvelope(val mid: ID, val fid: ID, val tid: ID?, val revision: Int, val date: Long, val receiveDate: Long, val from: YSArray<DeltaApiRecipient>, val replyTo: YSArray<DeltaApiRecipient>, val subject: String, val subjectInfo: DeltaApiSubject?, val cc: YSArray<DeltaApiRecipient>, val bcc: YSArray<DeltaApiRecipient>, val to: YSArray<DeltaApiRecipient>, val uidl: String?, val imapId: String?, val stid: String?, val firstline: String, val inReplyTo: String, val references: String, val rfcId: String, val size: Int, val threadCount: Int, val newCount: Int, val attachmentsCount: Int, val attachmentsFullSize: Int, val attachments: YSArray<DeltaApiAttachment>, val lids: YSArray<LabelID>, val types: YSArray<Int>) {
    companion object {
        @JvmStatic
        open fun fromJSONItem(jsonItem: JSONItem): DeltaApiEnvelope? {
            if (jsonItem.kind != JSONItemKind.map) {
                return null
            }
            val map = jsonItem as MapJSONItem
            val mid = idFromString(map.getString("mid"))!!
            val fid = idFromString(map.getString("fid"))!!
            val tid = idFromString(map.getString("threadId"))
            val revision = map.getInt32("revision")!!
            val date = int32ToInt64(map.getInt32("date")!!) * int64(1000)
            val receiveDate = int32ToInt64(map.getInt32("receiveDate")!!) * int64(1000)
            val from = extractDeltaApiRecipients(map.getArrayOrDefault("from", mutableListOf()))
            val replyTo = extractDeltaApiRecipients(map.getArrayOrDefault("replyTo", mutableListOf()))
            val subject = map.getString("subject")!!
            val subjectInfo = extractDeltaApiSubjectInfo(map.`get`("subjectInfo")!!)
            val cc = extractDeltaApiRecipients(map.getArrayOrDefault("cc", mutableListOf()))
            val bcc = extractDeltaApiRecipients(map.getArrayOrDefault("bcc", mutableListOf()))
            val to = extractDeltaApiRecipients(map.getArrayOrDefault("to", mutableListOf()))
            val uidl = map.getString("uidl")
            val imapId = map.getString("imapId")
            val stid = map.getString("stid")
            val firstline = map.getStringOrDefault("firstline", "")
            val inReplyTo = map.getString("inReplyTo")!!
            val references = map.getString("references")!!
            val rfcId = map.getString("rfcId")!!
            val size = map.getInt32("size")!!
            val threadCount = map.getInt32("threadCount")!!
            val newCount = map.getInt32("newCount")!!
            val attachmentsCount = map.getInt32("attachmentsCount")!!
            val attachmentsFullSize = map.getInt32("attachmentsFullSize")!!
            val attachments = extractDeltaApiAttachments(map.getArrayOrDefault("attachments", mutableListOf()))
            val labels = map.getArrayOrDefault("labels", mutableListOf()).map( {
                item ->
                (item as StringJSONItem).value
            })
            val types = map.getArrayOrDefault("types", mutableListOf()).map( {
                item ->
                JSONItemToInt32(item)!!
            })
            return DeltaApiEnvelope(mid, fid, tid, revision, date, receiveDate, from, replyTo, subject, subjectInfo, cc, bcc, to, uidl, imapId, stid, firstline, inReplyTo, references, rfcId, size, threadCount, newCount, attachmentsCount, attachmentsFullSize, attachments, labels, types)
        }

    }
}

private fun extractDeltaApiRecipients(items: YSArray<JSONItem>): YSArray<DeltaApiRecipient> {
    val result: YSArray<DeltaApiRecipient> = mutableListOf()
    for (item in items) {
        val recipient = extractDeltaApiRecipient(item)
        if (recipient != null) {
            result.add(recipient)
        }
    }
    return result
}

private fun extractDeltaApiRecipient(jsonItem: JSONItem): DeltaApiRecipient? {
    if (jsonItem.kind != JSONItemKind.map) {
        return null
    }
    val map = jsonItem as MapJSONItem
    val local = map.getString("local")!!
    val domain = map.getString("domain")!!
    val displayName = map.getStringOrDefault("displayName", "")
    return DeltaApiRecipient(local, domain, displayName)
}

private fun extractDeltaApiSubjectInfo(jsonItem: JSONItem): DeltaApiSubject? {
    if (jsonItem.kind != JSONItemKind.map) {
        return null
    }
    val map = jsonItem as MapJSONItem
    val type = map.getString("type")!!
    val prefix = map.getString("prefix")!!
    val subject = map.getString("subject")!!
    val postfix = map.getString("postfix")!!
    val isSplitted = map.getBoolean("isSplitted")!!
    return DeltaApiSubject(type, prefix, subject, postfix, isSplitted)
}

private fun extractDeltaApiAttachments(items: YSArray<JSONItem>): YSArray<DeltaApiAttachment> {
    val result: YSArray<DeltaApiAttachment> = mutableListOf()
    for (item in items) {
        val attachemnt = deltaApiAttachmentFromJSONItem(item)
        if (attachemnt != null) {
            result.add(attachemnt)
        }
    }
    return result
}

public fun deltaApiAttachmentFromJSONItem(jsonItem: JSONItem): DeltaApiAttachment? {
    if (jsonItem.kind != JSONItemKind.map) {
        return null
    }
    val map = jsonItem as MapJSONItem
    val hid = map.getString("m_hid")!!
    val contentType = map.getString("m_contentType")!!
    val fileName = map.getString("m_fileName")!!
    val size = map.getInt32("m_size")!!
    return DeltaApiAttachment(hid, contentType, fileName, size)
}

public fun deltaApiAttachmentToJSONItem(value: DeltaApiAttachment): MapJSONItem {
    return MapJSONItem().putString("m_hid", value.hid).putString("m_contentType", value.contentType).putString("m_fileName", value.fileName).putInt32("m_size", value.size)
}

