// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/delta-api/entities/delta-api-folder.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem
import com.yandex.xplat.common.int64

public enum class DeltaApiFolderType(val value: String) {
    user("user"),
    system("system"),
    ;
    override fun toString(): String = value
}
public fun stringToDeltaApiFolderType(value: String): DeltaApiFolderType? {
    when (value) {
        "user" -> {
            return DeltaApiFolderType.user
        }
        "system" -> {
            return DeltaApiFolderType.system
        }
        else -> {
            return null
        }
    }
}

public enum class DeltaApiFolderSymbol(val value: String) {
    inbox("inbox"),
    sent("sent"),
    trash("trash"),
    spam("spam"),
    draft("draft"),
    outbox("outbox"),
    archive("archive"),
    template("template"),
    discount("discount"),
    unsubscribe("unsubscribe"),
    zombie("zombie"),
    ;
    override fun toString(): String = value
}
public fun stringToDeltaApiFolderSymbol(value: String): DeltaApiFolderSymbol? {
    when (value) {
        "inbox" -> {
            return DeltaApiFolderSymbol.inbox
        }
        "sent" -> {
            return DeltaApiFolderSymbol.sent
        }
        "trash" -> {
            return DeltaApiFolderSymbol.trash
        }
        "spam" -> {
            return DeltaApiFolderSymbol.spam
        }
        "draft" -> {
            return DeltaApiFolderSymbol.draft
        }
        "outbox" -> {
            return DeltaApiFolderSymbol.outbox
        }
        "archive" -> {
            return DeltaApiFolderSymbol.archive
        }
        "template" -> {
            return DeltaApiFolderSymbol.template
        }
        "discount" -> {
            return DeltaApiFolderSymbol.discount
        }
        "unsubscribe" -> {
            return DeltaApiFolderSymbol.unsubscribe
        }
        "zombie" -> {
            return DeltaApiFolderSymbol.zombie
        }
        else -> {
            return null
        }
    }
}

public open class DeltaApiFolder private constructor(val fid: ID, val name: String, val parentId: ID?, val type: DeltaApiFolderType, val symbol: DeltaApiFolderSymbol?, val recentMessagesCount: Int, val messagesCount: Int, val createDate: String, val isThreadable: Boolean, val isSubscribedForSharedFolder: Boolean, val unreadMessagesCount: Int, val bytes: Long, val revision: Int, val isUnvisited: Boolean) {
    companion object {
        @JvmStatic
        open fun fromJSONItem(jsonItem: JSONItem): DeltaApiFolder? {
            if (jsonItem.kind != JSONItemKind.map) {
                return null
            }
            val map = jsonItem as MapJSONItem
            val fid = map.getInt64("id")!!
            val name = map.getString("name")!!
            val parentId = idFromString(map.getString("parentId"))
            val type = stringToDeltaApiFolderType(map.getString("type")!!)!!
            val symbol = stringToDeltaApiFolderSymbol(map.getString("symbol")!!)
            val recentMessagesCount = map.getInt32OrDefault("recentMessagesCount", 0)
            val messagesCount = map.getInt32OrDefault("messagesCount", 0)
            val createDate = map.getString("createDate")!!
            val isThreadable = map.getBoolean("isThreadable")!!
            val isSubscribedForSharedFolder = map.getBooleanOrDefault("isSubscribedForSharedFolder", false)
            val unreadMessagesCount = map.getInt32OrDefault("unreadMessagesCount", 0)
            val bytes = map.getInt64OrDefault("bytes", int64(0))
            val revision = map.getInt32("revision")!!
            val isUnvisited = map.getBooleanOrDefault("isUnvisited", false)
            return DeltaApiFolder(fid, name, parentId, type, symbol, recentMessagesCount, messagesCount, createDate, isThreadable, isSubscribedForSharedFolder, unreadMessagesCount, bytes, revision, isUnvisited)
        }

    }
}

