// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/delta-api/entities/delta-api-label.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem

public enum class DeltaApiLabelType(val value: String) {
    user("user"),
    social("social"),
    system("system"),
    status("status"),
    imap("imap"),
    threadWide("threadWide"),
    rpop("rpop"),
    phone("phone"),
    so("so"),
    so2("so2"),
    ;
    override fun toString(): String = value
}
public fun stringToDeltaApiLabelType(value: String): DeltaApiLabelType? {
    when (value) {
        "user" -> {
            return DeltaApiLabelType.user
        }
        "social" -> {
            return DeltaApiLabelType.social
        }
        "system" -> {
            return DeltaApiLabelType.system
        }
        "status" -> {
            return DeltaApiLabelType.status
        }
        "imap" -> {
            return DeltaApiLabelType.imap
        }
        "threadWide" -> {
            return DeltaApiLabelType.threadWide
        }
        "rpop" -> {
            return DeltaApiLabelType.rpop
        }
        "phone" -> {
            return DeltaApiLabelType.phone
        }
        "so" -> {
            return DeltaApiLabelType.so
        }
        "so2" -> {
            return DeltaApiLabelType.so2
        }
        else -> {
            return null
        }
    }
}

public enum class DeltaApiLabelSymbol(val value: String) {
    attached("attached_label"),
    spam("spam_label"),
    answered("answered_label"),
    recent("recent_label"),
    draft("draft_label"),
    deleted("deleted_label"),
    forwarded("forwarded_label"),
    important("important_label"),
    forMe("forMe_label"),
    noBody("noBody_label"),
    noAnswer("noAnswer_label"),
    hasUserLabels("hasUserLabels_label"),
    seen("seen_label"),
    pinned("pinned_label"),
    postmaster("postmaster_label"),
    mulcaShared("mulcaShared_label"),
    imap("imap_label"),
    append("append_label"),
    copy("copy_label"),
    synced("synced_label"),
    remindNoAnswer("remindNoAnswer_label"),
    notifyNoAnswer("notifyNoAnswer_label"),
    remindMessage("remindMessage_label"),
    notifyMessage("notifyMessage_label"),
    mute("mute_label"),
    delayedMessage("delayed_message"),
    undoMessage("undo_message"),
    hamon("hamon_label"),
    encrypted("encrypted_label"),
    ;
    override fun toString(): String = value
}
public fun stringToDeltaApiLabelSymbol(value: String): DeltaApiLabelSymbol? {
    when (value) {
        "attached_label" -> {
            return DeltaApiLabelSymbol.attached
        }
        "spam_label" -> {
            return DeltaApiLabelSymbol.spam
        }
        "answered_label" -> {
            return DeltaApiLabelSymbol.answered
        }
        "recent_label" -> {
            return DeltaApiLabelSymbol.recent
        }
        "draft_label" -> {
            return DeltaApiLabelSymbol.draft
        }
        "deleted_label" -> {
            return DeltaApiLabelSymbol.deleted
        }
        "forwarded_label" -> {
            return DeltaApiLabelSymbol.forwarded
        }
        "important_label" -> {
            return DeltaApiLabelSymbol.important
        }
        "forMe_label" -> {
            return DeltaApiLabelSymbol.forMe
        }
        "noBody_label" -> {
            return DeltaApiLabelSymbol.noBody
        }
        "noAnswer_label" -> {
            return DeltaApiLabelSymbol.noAnswer
        }
        "hasUserLabels_label" -> {
            return DeltaApiLabelSymbol.hasUserLabels
        }
        "seen_label" -> {
            return DeltaApiLabelSymbol.seen
        }
        "pinned_label" -> {
            return DeltaApiLabelSymbol.pinned
        }
        "postmaster_label" -> {
            return DeltaApiLabelSymbol.postmaster
        }
        "mulcaShared_label" -> {
            return DeltaApiLabelSymbol.mulcaShared
        }
        "imap_label" -> {
            return DeltaApiLabelSymbol.imap
        }
        "append_label" -> {
            return DeltaApiLabelSymbol.append
        }
        "copy_label" -> {
            return DeltaApiLabelSymbol.copy
        }
        "synced_label" -> {
            return DeltaApiLabelSymbol.synced
        }
        "remindNoAnswer_label" -> {
            return DeltaApiLabelSymbol.remindNoAnswer
        }
        "notifyNoAnswer_label" -> {
            return DeltaApiLabelSymbol.notifyNoAnswer
        }
        "remindMessage_label" -> {
            return DeltaApiLabelSymbol.remindMessage
        }
        "notifyMessage_label" -> {
            return DeltaApiLabelSymbol.notifyMessage
        }
        "mute_label" -> {
            return DeltaApiLabelSymbol.mute
        }
        "delayed_message" -> {
            return DeltaApiLabelSymbol.delayedMessage
        }
        "undo_message" -> {
            return DeltaApiLabelSymbol.undoMessage
        }
        "hamon_label" -> {
            return DeltaApiLabelSymbol.hamon
        }
        "encrypted_label" -> {
            return DeltaApiLabelSymbol.encrypted
        }
        else -> {
            return null
        }
    }
}

public open class DeltaApiLabel(val lid: LabelID, val name: String, val color: String, val messagesCount: Int, val creationTime: String, val type: DeltaApiLabelType?, val symbol: DeltaApiLabelSymbol?, val revision: Int) {
    companion object {
        @JvmStatic
        open fun fromJSONItem(jsonItem: JSONItem): DeltaApiLabel? {
            if (jsonItem.kind != JSONItemKind.map) {
                return null
            }
            val map = jsonItem as MapJSONItem
            val lid = map.getString("lid")!!
            val name = map.getString("name")!!
            val color = map.getStringOrDefault("color", "")
            val messagesCount = map.getInt32("messagesCount")!!
            val creationTime = map.getString("creationTime")!!
            val type = stringToDeltaApiLabelType(map.getStringOrDefault("type", ""))
            val symbol = stringToDeltaApiLabelSymbol(map.getStringOrDefault("symbol", ""))
            val revision = map.getInt32("revision")!!
            return DeltaApiLabel(lid, name, color, messagesCount, creationTime, type, symbol, revision)
        }

    }
}

