// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/draft/mail-send-request.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class MailSendRequest(val composeCheck: String, val cc: String?, val bcc: String?, val body: String, val references: String?, val inReplyTo: String?, val draftBase: String?, val narodAtt: String?, val parts: YSArray<String>?, val reply: String?, val forward: String?, val templateBase: String?, val attachIds: YSArray<String>?, var attachesCount: Int, val subject: String = "", val to: String = "", val fromName: String = "", val fromMailbox: String = "") {
    open fun asMapJSONItem(): MapJSONItem {
        return MapJSONItem().putString("compose_check", this.composeCheck).putString("subj", this.subject).putString("to", this.to).putStringIfPresent("cc", this.cc).putStringIfPresent("bcc", this.bcc).putString("from_name", this.fromName).putString("from_mailbox", this.fromMailbox).putString("send", this.body).putStringIfPresent("references", this.references).putStringIfPresent("inreplyto", this.inReplyTo).putStringIfPresent("draft_base", this.draftBase).putStringIfPresent("narod_att", this.narodAtt).putIfPresent("parts", this.getPartsJsonItem()).putStringIfPresent("reply", this.reply).putStringIfPresent("forward", this.forward).putStringIfPresent("template_base", this.templateBase).putIfPresent("att_ids", this.getAttachIdsJsonItem()).putString("ttype", "html")
    }

    open fun toBuilder(): MailSendRequestBuilder {
        return MailSendRequestBuilder().setComposeCheck(this.composeCheck).setCc(this.cc).setBcc(this.bcc).setBody(this.body).setReferences(this.references).setInReplyTo(this.inReplyTo).setDraftBase(this.draftBase).setNarodAtt(this.narodAtt).setParts(this.parts).setReply(this.reply).setForward(this.forward).setTemplateBase(this.templateBase).setAttachIds(this.attachIds).setSubject(this.subject).setTo(this.to).setFromName(this.fromName).setFromMailbox(this.fromMailbox)
    }

    private fun getPartsJsonItem(): ArrayJSONItem? {
        return if (this.parts == null) null else ArrayJSONItem(this.parts!!.map( {
            part ->
            StringJSONItem(part)
        }))
    }

    private fun getAttachIdsJsonItem(): ArrayJSONItem? {
        return if (this.attachIds == null) null else ArrayJSONItem(this.attachIds!!.map( {
            part ->
            StringJSONItem(part)
        }))
    }

}

public open class MailSendRequestBuilder {
    private var composeCheck: String = ""
    private var cc: String? = null
    private var bcc: String? = null
    private var body: String = ""
    private var references: String? = null
    private var inReplyTo: String? = null
    private var draftBase: String? = null
    private var narodAtt: String? = null
    private var parts: YSArray<String>? = null
    private var reply: String? = null
    private var forward: String? = null
    private var templateBase: String? = null
    private var attachIds: YSArray<String>? = null
    private var subject: String = ""
    private var to: String = ""
    private var fromName: String = ""
    private var fromMailbox: String = ""
    open fun setComposeCheck(composeCheck: String): MailSendRequestBuilder {
        this.composeCheck = composeCheck
        return this
    }

    open fun setCc(cc: String?): MailSendRequestBuilder {
        this.cc = cc
        return this
    }

    open fun setBcc(bcc: String?): MailSendRequestBuilder {
        this.bcc = bcc
        return this
    }

    open fun setBody(body: String): MailSendRequestBuilder {
        this.body = body
        return this
    }

    open fun setReferences(references: String?): MailSendRequestBuilder {
        this.references = references
        return this
    }

    open fun setInReplyTo(inReplyTo: String?): MailSendRequestBuilder {
        this.inReplyTo = inReplyTo
        return this
    }

    open fun setDraftBase(draftBase: String?): MailSendRequestBuilder {
        this.draftBase = draftBase
        return this
    }

    open fun setNarodAtt(narodAtt: String?): MailSendRequestBuilder {
        this.narodAtt = narodAtt
        return this
    }

    open fun setParts(parts: YSArray<String>?): MailSendRequestBuilder {
        this.parts = parts
        return this
    }

    open fun setReply(reply: String?): MailSendRequestBuilder {
        this.reply = reply
        return this
    }

    open fun setForward(forward: String?): MailSendRequestBuilder {
        this.forward = forward
        return this
    }

    open fun setTemplateBase(templateBase: String?): MailSendRequestBuilder {
        this.templateBase = templateBase
        return this
    }

    open fun setAttachIds(attachIds: YSArray<String>?): MailSendRequestBuilder {
        this.attachIds = attachIds
        return this
    }

    open fun setSubject(subject: String): MailSendRequestBuilder {
        this.subject = subject
        return this
    }

    open fun setTo(to: String): MailSendRequestBuilder {
        this.to = to
        return this
    }

    open fun setFromName(fromName: String): MailSendRequestBuilder {
        this.fromName = fromName
        return this
    }

    open fun setFromMailbox(fromMailbox: String): MailSendRequestBuilder {
        this.fromMailbox = fromMailbox
        return this
    }

    open fun build(): MailSendRequest {
        return MailSendRequest(this.composeCheck, this.cc, this.bcc, this.body, this.references, this.inReplyTo, this.draftBase, this.narodAtt, this.parts, this.reply, this.forward, this.templateBase, this.attachIds, this.attachIds?.size ?: 0, this.subject, this.to, this.fromName, this.fromMailbox)
    }

}

