// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/draft/save-draft-response.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class SaveDraftResponse(val status: NetworkStatus, val mid: ID?, val fid: ID?, val attachments: YSArray<MessageBodyAttach>?): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.status
    }

}

public fun saveDraftResponseFromJSONItem(item: JSONItem): SaveDraftResponse? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val statusObject = map.`get`("status")
    if (statusObject == null) {
        return null
    }
    val status = networkStatusFromJSONItem(statusObject)
    if (status == null || status.code != NetworkStatusCode.ok) {
        return SaveDraftResponse(status!!, ConstantIDs.noMessageID, ConstantIDs.noFolderID, mutableListOf())
    }
    val mid = map.getInt64("mid")
    val fid = map.getInt64("fid")
    val attachWrapperInner = map.`get`("attachments")
    if (attachWrapperInner == null) {
        return SaveDraftResponse(status, mid, fid, null)
    }
    val attachWrapper = attachWrapperInner as MapJSONItem
    val itemsJsonInner = attachWrapper.`get`("attachment")
    if (itemsJsonInner == null) {
        return SaveDraftResponse(status, mid, fid, null)
    }
    val itemsJson = itemsJsonInner as ArrayJSONItem
    val attachments: YSArray<MessageBodyAttach> = itemsJson.asArray().map( {
        value ->
        messageBodyAttachFromJSONItem(value)!!
    })
    return SaveDraftResponse(status, mid, fid, attachments)
}

