// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/folder/folder.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public enum class FolderType(val value: Int) {
    inbox(1),
    user(2),
    outgoing(3),
    sent(4),
    draft(5),
    spam(6),
    trash(7),
    archive(8),
    templates(9),
    discount(10),
    other(11),
    unsubscribe(12),
    tab_relevant(100),
    tab_news(101),
    tab_social(102),
    ;
    fun toInt(): Int = value
}
public fun int32ToFolderType(value: Int): FolderType {
    when (value) {
        1 -> {
            return FolderType.inbox
        }
        2 -> {
            return FolderType.user
        }
        3 -> {
            return FolderType.outgoing
        }
        4 -> {
            return FolderType.sent
        }
        5 -> {
            return FolderType.draft
        }
        6 -> {
            return FolderType.spam
        }
        7 -> {
            return FolderType.trash
        }
        8 -> {
            return FolderType.archive
        }
        9 -> {
            return FolderType.templates
        }
        10 -> {
            return FolderType.discount
        }
        11 -> {
            return FolderType.other
        }
        12 -> {
            return FolderType.unsubscribe
        }
        100 -> {
            return FolderType.tab_relevant
        }
        101 -> {
            return FolderType.tab_news
        }
        102 -> {
            return FolderType.tab_social
        }
        else -> {
            return FolderType.other
        }
    }
}

public fun folderTypeToInt32(value: FolderType): Int {
    when (value) {
        FolderType.inbox -> {
            return 1
        }
        FolderType.user -> {
            return 2
        }
        FolderType.outgoing -> {
            return 3
        }
        FolderType.sent -> {
            return 4
        }
        FolderType.draft -> {
            return 5
        }
        FolderType.spam -> {
            return 6
        }
        FolderType.trash -> {
            return 7
        }
        FolderType.archive -> {
            return 8
        }
        FolderType.templates -> {
            return 9
        }
        FolderType.discount -> {
            return 10
        }
        FolderType.other -> {
            return 11
        }
        FolderType.unsubscribe -> {
            return 12
        }
        FolderType.tab_relevant -> {
            return 100
        }
        FolderType.tab_news -> {
            return 101
        }
        FolderType.tab_social -> {
            return 102
        }
    }
}

public fun isFolderOfThreadedType(type: FolderType): Boolean {
    when (type) {
        FolderType.trash -> {
            return false
        }
        FolderType.outgoing -> {
            return false
        }
        FolderType.templates -> {
            return false
        }
        FolderType.draft -> {
            return false
        }
        FolderType.spam -> {
            return false
        }
        FolderType.archive -> {
            return false
        }
        else -> {
            return true
        }
    }
}

public fun tabTypeFromName(value: String): FolderType? {
    when (value) {
        "relevant" -> {
            return FolderType.tab_relevant
        }
        "news" -> {
            return FolderType.tab_news
        }
        "social" -> {
            return FolderType.tab_social
        }
        else -> {
            return null
        }
    }
}

public fun isFolderOfTabType(type: FolderType): Boolean {
    when (type) {
        FolderType.tab_relevant -> {
            return true
        }
        FolderType.tab_news -> {
            return true
        }
        FolderType.tab_social -> {
            return true
        }
        else -> {
            return false
        }
    }
}

public fun deltaApiFolderTypeAndSymbolToFolderType(type: DeltaApiFolderType, symbol: DeltaApiFolderSymbol?): FolderType {
    if (type == DeltaApiFolderType.user) {
        return FolderType.user
    }
    if (symbol == null) {
        return FolderType.other
    }
    when (symbol!!) {
        DeltaApiFolderSymbol.inbox -> {
            return FolderType.inbox
        }
        DeltaApiFolderSymbol.sent -> {
            return FolderType.sent
        }
        DeltaApiFolderSymbol.trash -> {
            return FolderType.trash
        }
        DeltaApiFolderSymbol.spam -> {
            return FolderType.spam
        }
        DeltaApiFolderSymbol.draft -> {
            return FolderType.draft
        }
        DeltaApiFolderSymbol.outbox -> {
            return FolderType.outgoing
        }
        DeltaApiFolderSymbol.archive -> {
            return FolderType.archive
        }
        DeltaApiFolderSymbol.template -> {
            return FolderType.templates
        }
        DeltaApiFolderSymbol.discount -> {
            return FolderType.discount
        }
        DeltaApiFolderSymbol.unsubscribe -> {
            return FolderType.unsubscribe
        }
        DeltaApiFolderSymbol.zombie -> {
            return FolderType.other
        }
        else -> {
            return FolderType.other
        }
    }
}

public enum class FolderSyncType(val value: Int) {
    doNotSync(0),
    silentSync(1),
    pushSync(2),
    ;
    fun toInt(): Int = value
}
public fun int32ToFolderSyncType(value: Int): FolderSyncType {
    when (value) {
        0 -> {
            return FolderSyncType.doNotSync
        }
        1 -> {
            return FolderSyncType.silentSync
        }
        2 -> {
            return FolderSyncType.pushSync
        }
        else -> {
            throw Error("Unknown FolderSyncType for ${value}")
        }
    }
}

public fun folderSyncTypeToInt32(value: FolderSyncType): Int {
    when (value) {
        FolderSyncType.doNotSync -> {
            return 0
        }
        FolderSyncType.silentSync -> {
            return 1
        }
        FolderSyncType.pushSync -> {
            return 2
        }
    }
}

public open class Folder(val fid: ID, val type: FolderType, val name: String?, val position: Int, val parent: ID?, val unreadCounter: Int, val totalCounter: Int) {
}

public fun folderFromJSONItem(item: JSONItem): Folder? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val fid = idFromString(map.getString("fid")!!)!!
    val parent = idFromString(nullIfEmptyString(map.getString("parent")!!))
    val name = map.getString("display_name")
    val unread = map.getInt32("count_unread")!!
    val total = map.getInt32("count_all")!!
    val type = int32ToFolderType(map.getInt32("type")!!)
    val position = stringToInt32((map.getMap("options")!!.`get`("position")!! as StringJSONItem).value)!!
    return Folder(fid, type, name, position, parent, unread, total)
}

