// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/label/label.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public enum class LabelType(val value: Int) {
    user(1),
    system(3),
    important(6),
    ;
    fun toInt(): Int = value
}
public fun int32ToLabelType(value: Int): LabelType {
    when (value) {
        1 -> {
            return LabelType.user
        }
        3 -> {
            return LabelType.system
        }
        6 -> {
            return LabelType.important
        }
        else -> {
            return LabelType.system
        }
    }
}

public fun labelTypeToInt32(value: LabelType): Int {
    when (value) {
        LabelType.user -> {
            return 1
        }
        LabelType.system -> {
            return 3
        }
        LabelType.important -> {
            return 6
        }
    }
}

public open class Label(val lid: LabelID, val type: LabelType, val name: String?, val unreadCounter: Int, val totalCounter: Int, val color: Int, val symbol: Long) {
}

public fun labelFromJSONItem(item: JSONItem): Label? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val lid = map.getString("lid")!!
    val name = map.getString("display_name")
    val unread = map.getInt32("count_unread")!!
    val total = map.getInt32("count_all")!!
    val type = int32ToLabelType(map.getInt32("type")!!)
    val colorString = map.getString("color")!!
    val color = stringToInt32(colorString, 16) ?: 0
    return Label(lid, type, name, unread, total, color, int64(0))
}

public fun deltaApiLabelTypeAndSymbolToLabelType(type: DeltaApiLabelType?, symbol: DeltaApiLabelSymbol?): LabelType {
    if (type == DeltaApiLabelType.user) {
        return LabelType.user
    }
    if (symbol != null) {
        when (symbol!!) {
            DeltaApiLabelSymbol.important -> {
                return LabelType.important
            }
            else -> {
                return LabelType.system
            }
        }
    }
    return LabelType.system
}

