// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/message/message-header-response.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem

public open class MessageHeaderResponse(val status: NetworkStatus, val message: MessageMeta?): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.status
    }

}

public fun messageHeaderResponseFromJSONItem(item: JSONItem): MessageHeaderResponse? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val statusObject = map.`get`("status")
    if (statusObject == null) {
        return null
    }
    val status = networkStatusFromJSONItem(statusObject)!!
    if (status.code != NetworkStatusCode.ok) {
        return MessageHeaderResponse(status, null)
    }
    val messageMetaJson = map.`get`("message")
    if (messageMetaJson == null || messageMetaJson.kind != JSONItemKind.map) {
        return null
    }
    val messageMeta = messageMetaFromJSONItem(messageMetaJson as MapJSONItem)
    return MessageHeaderResponse(status, messageMeta)
}

