// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/message/message-meta.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class MessageMeta(val mid: ID, val fid: ID, val tid: ID?, val lid: YSArray<LabelID>, val subjectEmpty: Boolean, val subjectPrefix: String?, val subjectText: String, val firstLine: String, val sender: String, val unread: Boolean, val searchOnly: Boolean, val showFor: String?, val timestamp: Long, val hasAttach: Boolean, val attachments: Attachments?, val typeMask: Int, val threadCount: String? = null) {
    open fun toBuilder(): MessageMetaBuilder {
        return MessageMetaBuilder(this)
    }

}

public open class MessageMetaBuilder(messageMeta: MessageMeta) {
    private var mid: ID
    private var fid: ID
    private var tid: ID?
    private var subjEmpty: Boolean
    private var subjPrefix: String?
    private var subjText: String
    private var firstLine: String
    private var sender: String
    private var unread: Boolean
    private var searchOnly: Boolean
    private var showFor: String?
    private var timestamp: Long
    private var hasAttach: Boolean
    private var typeMask: Int
    private var lids: YSArray<LabelID>
    private var attachments: Attachments?
    init {
        this.mid = messageMeta.mid
        this.fid = messageMeta.fid
        this.tid = messageMeta.tid
        this.subjEmpty = messageMeta.subjectEmpty
        this.subjPrefix = messageMeta.subjectPrefix
        this.subjText = messageMeta.subjectText
        this.firstLine = messageMeta.firstLine
        this.sender = messageMeta.sender
        this.unread = messageMeta.unread
        this.searchOnly = messageMeta.searchOnly
        this.showFor = messageMeta.showFor
        this.timestamp = messageMeta.timestamp
        this.hasAttach = messageMeta.hasAttach
        this.typeMask = messageMeta.typeMask
        this.lids = messageMeta.lid
        this.attachments = messageMeta.attachments
    }
    open fun build(): MessageMeta {
        return MessageMeta(this.mid, this.fid, this.tid, this.lids, this.subjEmpty, this.subjPrefix, this.subjText, this.firstLine, this.sender, this.unread, this.searchOnly, this.showFor, this.timestamp, this.hasAttach, this.attachments, this.typeMask)
    }

    open fun getMid(): ID {
        return this.mid
    }

    open fun setMid(mid: ID): MessageMetaBuilder {
        this.mid = mid
        return this
    }

    open fun setFid(fid: ID): MessageMetaBuilder {
        this.fid = fid
        return this
    }

    open fun setTid(tid: ID): MessageMetaBuilder {
        this.tid = tid
        return this
    }

    open fun setLids(lids: YSArray<LabelID>): MessageMetaBuilder {
        this.lids = lids
        return this
    }

    open fun setSubjEmpty(subjEmpty: Boolean): MessageMetaBuilder {
        this.subjEmpty = subjEmpty
        return this
    }

    open fun setSubjPrefix(subjPrefix: String?): MessageMetaBuilder {
        this.subjPrefix = subjPrefix
        return this
    }

    open fun setSubjText(subjText: String): MessageMetaBuilder {
        this.subjText = subjText
        return this
    }

    open fun setFirstLine(firstLine: String): MessageMetaBuilder {
        this.firstLine = firstLine
        return this
    }

    open fun setSender(sender: String): MessageMetaBuilder {
        this.sender = sender
        return this
    }

    open fun setUnread(unread: Boolean): MessageMetaBuilder {
        this.unread = unread
        return this
    }

    open fun setSearchOnly(searchOnly: Boolean): MessageMetaBuilder {
        this.searchOnly = searchOnly
        return this
    }

    open fun setShowFor(showFor: String?): MessageMetaBuilder {
        this.showFor = showFor
        return this
    }

    open fun setTimestamp(timestamp: Long): MessageMetaBuilder {
        this.timestamp = timestamp
        return this
    }

    open fun setHasAttach(hasAttach: Boolean): MessageMetaBuilder {
        this.hasAttach = hasAttach
        return this
    }

    open fun setTypeMask(typeMask: Int): MessageMetaBuilder {
        this.typeMask = typeMask
        return this
    }

    open fun setAttachments(attachments: Attachments?): MessageMetaBuilder {
        this.attachments = attachments
        return this
    }

}

public open class Attachments(val attachments: YSArray<Attachment>) {
}

public open class Attachment(val hid: String, val displayName: String, val fileClass: String, val isDisk: Boolean, val size: Long, val mimeType: String, val previewSupported: Boolean, val previewUrl: String?, val downloadUrl: String, val isInline: Boolean, val contentID: String?) {
}

public fun attachmentsFromJSONItem(json: JSONItem): Attachments? {
    if (json.kind != JSONItemKind.map) {
        return null
    }
    val attachments: YSArray<Attachment> = mutableListOf()
    for (item in (json as MapJSONItem).getArrayOrDefault("attachments", mutableListOf())) {
        if (item.kind == JSONItemKind.map) {
            val map = item as MapJSONItem
            attachments.add(Attachment(map.getString("hid")!!, map.getString("display_name")!!, map.getString("class")!!, map.getBooleanOrDefault("narod", false), map.getInt64OrDefault("size", int64(0)), map.getString("mime_type")!!, map.getBooleanOrDefault("preview_supported", false), map.getString("preview_url"), map.getString("download_url")!!, map.getBooleanOrDefault("is_inline", false), map.getString("content_id")))
        }
    }
    return Attachments(attachments)
}

public fun messageMetaFromJSONItem(json: JSONItem): MessageMeta? {
    if (json.kind != JSONItemKind.map) {
        return null
    }
    val map = json as MapJSONItem
    val mid = idFromString(map.getString("mid"))!!
    val fid = idFromString(map.getString("fid"))!!
    val tid = idFromString(map.getString("tid"))
    val lids = map.getArrayOrDefault("lid", mutableListOf()).map( {
        item ->
        (item as StringJSONItem).value
    })
    val subjectEmpty = map.getBoolean("subjEmpty")!!
    val subjectPrefix = map.getString("subjPrefix")!!
    val subjectText = map.getString("subjText")!!
    val firstLine = map.getStringOrDefault("firstLine", "")
    val recipient = recipientFromJSONItem(map.`get`("from")!!)!!
    val sender = EmailWithName.fromNameAndEmail(recipient.name, recipient.email).asString()
    val isUnread = map.getArray("status")!!.map( {
        statusItem ->
        JSONItemToInt32(statusItem) ?: 0
    }).contains(1)
    val timestamp = stringToInt64(map.getString("utc_timestamp")!!)!! * int64(1000)
    val hasAttach = map.getBoolean("hasAttach")!!
    val types = messageTypeMaskFromServerMessageTypes(map.getArray("types")!!.map( {
        item ->
        stringToInt32((item as StringJSONItem).value)!!
    }))
    val attachments: Attachments? = if (map.hasKey("attachments")) attachmentsFromJSONItem(map.`get`("attachments")!!) else null
    val threadCount = map.getString("threadCount")
    return MessageMeta(mid, fid, tid, lids, subjectEmpty, subjectPrefix, subjectText, firstLine, sender, isUnread, false, null, timestamp, hasAttach, attachments, types, threadCount)
}

public fun deltaApiEnvelopeToMessageMeta(envelope: DeltaApiEnvelope): MessageMeta {
    val isSubjectEmpty = isDeltaApiSubjectEmpty(envelope.subjectInfo)
    val mid = envelope.mid
    val fid = envelope.fid
    val tid = envelope.tid
    return MessageMeta(mid, fid, tid, envelope.lids, isSubjectEmpty, if (envelope.subjectInfo != null) envelope.subjectInfo!!.prefix.trim() else null, if (isSubjectEmpty) "" else envelope.subjectInfo!!.subject, envelope.firstline, if (envelope.from.size > 0) envelope.from[0].asString() else "", !containsReadLabel(envelope.lids), false, null, envelope.date, envelope.attachmentsCount > 0, attachmentsFromDeltaApiAttachments(envelope.attachments), messageTypeMaskFromServerMessageTypes(envelope.types))
}

public fun attachmentsFromDeltaApiAttachments(attachments: YSArray<DeltaApiAttachment>): Attachments {
    return Attachments(attachments.filter( {
        att ->
        att.fileName != "narod_attachment_links.html"
    }).map(__LBL__MessageMeta_1@ {
        att ->
        val contentType = att.contentType.split("/")[0]
        val previewSupported = contentType == "image"
        return@__LBL__MessageMeta_1 Attachment(att.hid, att.fileName, contentType, false, int32ToInt64(att.size), att.contentType, previewSupported, if (previewSupported) "" else null, "", false, null)
    }))
}

public fun getMidToTimestampMap(metas: YSArray<MessageMeta>): YSMap<ID, Long> {
    return metas.reduce( {
        res, item ->
        res.set(item.mid, item.timestamp)
    }
, mutableMapOf<ID, Long>())
}

public fun containsReadLabel(lids: YSArray<LabelID>): Boolean {
    return lids.contains("FAKE_SEEN_LBL")
}

