// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/message/message-response-header.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem

public open class MessageResponseHeaderPayload(val md5: String, val countTotal: Int, val countUnread: Int, val modified: Boolean, val batchCount: Int) {
}

public open class MessagesResponseHeader private constructor(val error: Int, val payload: MessageResponseHeaderPayload?) {
    companion object {
        @JvmStatic
        open fun withError(error: Int): MessagesResponseHeader {
            return MessagesResponseHeader(error, null)
        }

        @JvmStatic
        open fun withPayload(md5: String, countTotal: Int, countUnread: Int, modified: Boolean, batchCount: Int): MessagesResponseHeader {
            return MessagesResponseHeader(1, MessageResponseHeaderPayload(md5, countTotal, countUnread, modified, batchCount))
        }

    }
}

public fun messageResponseHeaderFromJSONItem(item: JSONItem): MessagesResponseHeader? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val error = map.getInt32("error")!!
    if (error != 1) {
        return MessagesResponseHeader.withError(error)
    }
    val md5 = map.getString("md5")!!
    val countTotal = map.getInt32("countTotal")!!
    val countUnread = map.getInt32("countUnread")!!
    val modified = map.getBoolean("modified")!!
    val batchCount = map.getInt32("batchCount")!!
    return MessagesResponseHeader.withPayload(md5, countTotal, countUnread, modified, batchCount)
}

