// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/message/messages-response.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class MessageResponse(val status: NetworkStatus, val payload: YSArray<MessageResponsePayload>?): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.status
    }

}

public open class MessageResponsePayload(val header: MessagesResponseHeader, val items: YSArray<MessageMeta>) {
}

public fun messageResponseFromJSONItem(item: JSONItem): MessageResponse? {
    if (item.kind == JSONItemKind.array) {
        val array = item as ArrayJSONItem
        return MessageResponse(NetworkStatus(NetworkStatusCode.ok), messageResponsePayloadFromJSONItems(array))
    } else if (item.kind == JSONItemKind.map) {
        val map = item as MapJSONItem
        if (map.hasKey("status")) {
            return MessageResponse(networkStatusFromJSONItem(map.`get`("status")!!)!!, null)
        }
    }
    return null
}

private fun messageResponsePayloadFromJSONItems(items: ArrayJSONItem): YSArray<MessageResponsePayload> {
    return items.asArray().filter( {
        item ->
        item.kind == JSONItemKind.map
    }).map(__LBL__MessagesResponse_1@ {
        item ->
        val map = item as MapJSONItem
        val header = messageResponseHeaderFromJSONItem(map.`get`("header")!!)
        val messages = undefinedToNull(nullthrows(map.getMap("messageBatch")).get("messages"))
        return@__LBL__MessagesResponse_1 MessageResponsePayload(header ?: MessagesResponseHeader.withError(-1), if (messages != null) messageMetasFromJSONItem(messages as ArrayJSONItem) else mutableListOf())
    })
}

public fun messageMetasFromJSONItem(items: ArrayJSONItem): YSArray<MessageMeta> {
    val result: YSArray<MessageMeta> = mutableListOf()
    for (item in items.asArray()) {
        val message = messageMetaFromJSONItem(item as MapJSONItem)
        if (message != null) {
            result.add(message)
        }
    }
    return result
}

