// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/recipient/recipient.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem

public open class Recipient(val email: String, val name: String?, val type: RecipientType) {
}

public enum class RecipientType(val value: Int) {
    to(1),
    from(2),
    cc(3),
    bcc(4),
    replyTo(5),
    ;
    fun toInt(): Int = value
}
public fun int32ToRecipientType(value: Int): RecipientType? {
    when (value) {
        1 -> {
            return RecipientType.to
        }
        2 -> {
            return RecipientType.from
        }
        3 -> {
            return RecipientType.cc
        }
        4 -> {
            return RecipientType.bcc
        }
        5 -> {
            return RecipientType.replyTo
        }
        else -> {
            return null
        }
    }
}

public fun recipientTypeToInt32(value: RecipientType): Int {
    when (value) {
        RecipientType.to -> {
            return 1
        }
        RecipientType.from -> {
            return 2
        }
        RecipientType.cc -> {
            return 3
        }
        RecipientType.bcc -> {
            return 4
        }
        RecipientType.replyTo -> {
            return 5
        }
    }
}

public fun recipientFromJSONItem(item: JSONItem): Recipient? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val email = map.getString("email")!!
    val name = map.getString("name")!!
    val type = int32ToRecipientType(map.getInt32("type")!!)
    if (type == null) {
        return null
    }
    return Recipient(email, name, type)
}

public fun recipientToJSONItem(recipient: Recipient): JSONItem {
    val item = MapJSONItem()
    item.putString("email", recipient.email)
    if (recipient.name != null) {
        item.putString("name", recipient.name)
    }
    item.putInt32("type", recipientTypeToInt32(recipient.type))
    return item
}

