// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/search/search-response.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class SearchResponse(val status: NetworkStatus, val messages: YSArray<MessageMeta>): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.status
    }

}

public fun searchResponseFromJSONItem(item: JSONItem): SearchResponse? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val statusObject = map.`get`("status")
    if (statusObject == null) {
        return null
    }
    val status = networkStatusFromJSONItem(statusObject)!!
    if (status.code != NetworkStatusCode.ok) {
        return SearchResponse(status, mutableListOf())
    }
    val messageMetasJson = map.`get`("messages")!!
    val messageMetas = if (messageMetasJson.kind == JSONItemKind.array) messageMetasFromJSONItem(messageMetasJson as ArrayJSONItem) else mutableListOf()
    return SearchResponse(status, messageMetas)
}

