// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/settings/settings-entities.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class SettingsResponse(val status: NetworkStatus, val payload: StatusResponsePayload?): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.status
    }

}

public open class StatusResponsePayload(val accountInformation: AccountInformation, val userParameters: UserParameters, val settingsSetup: SettingsSetup) {
}

public fun settingsResponseFromJSONItem(item: JSONItem): SettingsResponse? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val status = networkStatusFromJSONItem(map.`get`("status")!! as MapJSONItem)!!
    if (status.code != NetworkStatusCode.ok) {
        return SettingsResponse(status, null)
    }
    val accountInformation = accountInformationFromJSONItem(map.getMap("account_information")!!.`get`("account-information")!! as MapJSONItem)
    val userParameters = userParametersFromJSONItem(map.getMap("get_user_parameters")!!.`get`("body")!! as MapJSONItem)
    val settingsSetup = settingsSetupFromJSONItem(map.getMap("settings_setup")!!.`get`("body")!! as MapJSONItem)
    return SettingsResponse(status, StatusResponsePayload(accountInformation, userParameters, settingsSetup))
}

public open class AccountInformation(val uid: String, val suid: String, val emails: YSArray<Email>, val composeCheck: String) {
}

private fun accountInformationFromJSONItem(item: MapJSONItem): AccountInformation {
    val uid = item.getString("uid")!!
    val suid = item.getString("suid")!!
    val composeCheck = item.getString("compose-check")!!
    val emails: YSArray<Email> = mutableListOf()
    val emailsArray = item.getMap("emails")!!.`get`("email")!! as ArrayJSONItem
    for (element in emailsArray.asArray()) {
        val mapElement = element as MapJSONItem
        val login = mapElement.getString("login")!!
        val domain = mapElement.getStringOrDefault("domain", "")
        emails.add(Email(login, domain))
    }
    return AccountInformation(uid, suid, emails, composeCheck)
}

public open class UserParameters(val seasonsModifier: String?, val canReadTabs: Boolean, val showFoldersTabs: Boolean) {
}

private fun userParametersFromJSONItem(item: MapJSONItem): UserParameters {
    return UserParameters(item.getString("seasons-modifier"), item.getString("can_read_tabs") == "on", item.getString("show_folders_tabs") == "on")
}

public enum class SignaturePlace(val value: Int) {
    none(0),
    atEnd(1),
    afterReply(2),
    ;
    fun toInt(): Int = value
}
public fun signaturePlaceToInt32(value: SignaturePlace): Int {
    when (value) {
        SignaturePlace.none -> {
            return 0
        }
        SignaturePlace.atEnd -> {
            return 1
        }
        SignaturePlace.afterReply -> {
            return 2
        }
    }
}

public fun int32ToSignaturePlace(value: Int): SignaturePlace {
    when (value) {
        0 -> {
            return SignaturePlace.none
        }
        1 -> {
            return SignaturePlace.atEnd
        }
        2 -> {
            return SignaturePlace.afterReply
        }
        else -> {
            return SignaturePlace.none
        }
    }
}

public open class SettingsSetup(val colorScheme: String, val fromName: String, val defaultEmail: String, val folderThreadView: Boolean, val quotationChar: String, val mobileSign: String, val signatureTop: SignaturePlace, val replyTo: YSArray<String>) {
}

private fun settingsSetupFromJSONItem(item: MapJSONItem): SettingsSetup {
    val colorScheme = item.getString("color_scheme")!!
    val fromName = item.getString("from_name")!!
    val defaultEmail = item.getString("default_email")!!
    val folderThreadView = item.getString("folder_thread_view") == "on"
    val mobileSignature = item.getString("mobile_sign")!!
    val quotationChar = item.getString("quotation_char")!!
    val signatureOnTop = if (item.hasKey("signature_top")) if (item.getString("signature_top") == "on") SignaturePlace.afterReply else SignaturePlace.atEnd else SignaturePlace.none
    val replyTo: YSArray<String> = mutableListOf()
    val replyToItem = item.getMap("reply_to")!!.`get`("item")!!
    if (replyToItem.kind == JSONItemKind.array) {
        val replyToArray = replyToItem as ArrayJSONItem
        for (array in replyToArray.asArray()) {
            if (array.kind == JSONItemKind.string) {
                replyTo.add((array as StringJSONItem).value)
            }
        }
    }
    return SettingsSetup(colorScheme, fromName, defaultEmail, folderThreadView, quotationChar, mobileSignature, signatureOnTop, replyTo)
}

