// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/status/network-status.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.JSONItem
import com.yandex.xplat.common.JSONItemKind
import com.yandex.xplat.common.MapJSONItem
import com.yandex.xplat.common.emptyStringIfNull

public enum class NetworkStatusCode(val value: Int) {
    ok(1),
    temporaryError(2),
    permanentError(3),
    authenticationError(2001),
    ;
    fun toInt(): Int = value
}
private fun networkStatusCodeFromInt32(value: Int): NetworkStatusCode {
    when (value) {
        1 -> {
            return NetworkStatusCode.ok
        }
        2 -> {
            return NetworkStatusCode.temporaryError
        }
        3 -> {
            return NetworkStatusCode.permanentError
        }
        else -> {
            if (value > 2000) {
                return NetworkStatusCode.authenticationError
            }
            return NetworkStatusCode.temporaryError
        }
    }
}

public open class NetworkStatus(val code: NetworkStatusCode, val trace: String? = null, val phrase: String? = null) {
    open fun getErrorMessage(): String {
        val builder = StringBuilder()
        if (MailApiAuthError.isAuthError(this)) {
            builder.add("Authentication error; ")
        } else if (this.code == NetworkStatusCode.permanentError) {
            builder.add("PERM error; ")
        } else if (this.code == NetworkStatusCode.temporaryError) {
            builder.add("TEMP error; ")
        } else {
            return "No errors, status is OK"
        }
        builder.add("Phrase = ${emptyStringIfNull(this.phrase)}; ")
        builder.add("Trace = ${emptyStringIfNull(this.trace)};")
        return builder.build()
    }

}

public fun networkStatusFromJSONItem(item: JSONItem): NetworkStatus? {
    if (item.kind != JSONItemKind.map) {
        return null
    }
    val map = item as MapJSONItem
    val statusCode = networkStatusCodeFromInt32(map.getInt32("status")!!)
    val trace = map.getString("trace")
    val phrase = map.getString("phrase")
    return NetworkStatus(statusCode, trace, phrase)
}

