// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/entities/thread/threads-response.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class ThreadResponse(val status: NetworkStatus, val payload: YSArray<ThreadResponsePayload>?): ResponseWithStatus {
    open override fun networkStatus(): NetworkStatus {
        return this.status
    }

}

public open class ThreadResponsePayload(val header: MessagesResponseHeader, val items: YSArray<ThreadMeta>) {
}

public fun threadResponseFromJSONItem(item: JSONItem): ThreadResponse? {
    if (item.kind == JSONItemKind.array) {
        val array = item as ArrayJSONItem
        return ThreadResponse(NetworkStatus(NetworkStatusCode.ok), threadResponsePayloadFromJSONItems(array)!!)
    } else if (item.kind == JSONItemKind.map) {
        val map = item as MapJSONItem
        if (map.hasKey("status")) {
            return ThreadResponse(networkStatusFromJSONItem(map.`get`("status")!!)!!, null)
        }
    }
    return null
}

private fun threadResponsePayloadFromJSONItems(items: ArrayJSONItem): YSArray<ThreadResponsePayload>? {
    return items.asArray().filter( {
        item ->
        item.kind == JSONItemKind.map
    }).map(__LBL__ThreadsResponse_1@ {
        item ->
        val map = item as MapJSONItem
        val header = messageResponseHeaderFromJSONItem(map.`get`("header")!! as MapJSONItem)
        val batch = undefinedToNull(map.getMap("messageBatch")?.get("messages"))
        return@__LBL__ThreadsResponse_1 ThreadResponsePayload(header ?: MessagesResponseHeader.withError(-1), if (batch != null) threadMetasFromJSONItem(batch as ArrayJSONItem) else mutableListOf())
    })
}

private fun threadMetasFromJSONItem(items: ArrayJSONItem): YSArray<ThreadMeta> {
    val result: YSArray<ThreadMeta> = mutableListOf()
    for (item in items.asArray()) {
        val message = threadMetaFromJSONItem(item as MapJSONItem)
        if (message != null) {
            result.add(message)
        }
    }
    return result
}

