// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM api/network/default-network-interceptor.ts >>>

package com.yandex.xplat.mapi

import com.yandex.xplat.common.*

public open class DefaultNetworkInterceptor(private val platform: Platform, private val userAgent: String, private val extraBuilder: () -> NetworkExtra): NetworkInterceptor {
    open override fun intercept(originalRequest: NetworkRequest): XPromise<NetworkRequest> {
        return resolve(this.interceptSync(originalRequest))
    }

    open fun interceptSync(originalRequest: NetworkRequest): NetworkRequest {
        return SealedNetworkRequest(originalRequest.method(), originalRequest.targetPath(), originalRequest.params(), this.updateUrlExtra(originalRequest.urlExtra()), this.updateHeadersExtra(originalRequest.headersExtra()), originalRequest.encoding())
    }

    private fun updateUrlExtra(urlExtra: NetworkUrlExtra): NetworkUrlExtra {
        val networkExtra = this.extraBuilder()
        urlExtra.putString("client", platformToClient(this.platform)).putString("app_state", if (networkExtra.foreground) "foreground" else "background")
        if (networkExtra.uuid.length > 0) {
            urlExtra.putString("uuid", networkExtra.uuid)
        }
        return urlExtra
    }

    private fun updateHeadersExtra(headersExtra: NetworkHeadersExtra): NetworkHeadersExtra {
        return headersExtra.putString("User-Agent", this.userAgent)
    }

}

