// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM fuzzing/fuzzer.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.split

public open class Fuzzer(private var random: RandomProvider = PseudoRandomProvider.INSTANCE) {
    open fun naughtyString(minLength: Int): String {
        val result: YSArray<String> = mutableListOf()
        var length: Int = 0
        while (length < minLength) {
            val str = fuzzStrings()[randomInt(this.random, 0, fuzzStrings().size)]
            result.add(str)
            length += str.split("").size
        }
        return result.joinToString("")
    }

    open fun unicodeString(length: Int): String {
        val result: YSArray<String> = mutableListOf()
        while (result.size < length) {
            val unicode = Fuzzer.unicodeAll[randomInt(this.random, 0, Fuzzer.unicodeAll.size)]
            result.add(unicode[randomInt(this.random, 0, unicode.size)])
        }
        return result.joinToString("")
    }

    open fun fuzzyTitle(random: RandomProvider, minLength: Int = 100): String {
        if (randomInt(random, 0, 2) == 0) {
            return this.naughtyString(minLength)
        } else {
            return this.unicodeString(minLength)
        }
    }

    open fun fuzzyBody(random: RandomProvider, minLength: Int = 10000): String {
        return this.fuzzyTitle(random, minLength)
    }

    open fun fuzzyAttachment(random: RandomProvider, type: AttachmentType = AttachmentType.ZIP): String {
        val filename = this.naughtyString(20)
        return "/c/attachment/${type}/${filename}"
    }

    open fun fuzzyValidEmail(): String {
        return fuzzValidEmails()[randomInt(this.random, 0, fuzzValidEmails().size)]
    }

    open fun fuzzyInvalidEmail(): String {
        return fuzzInvalidEmails()[randomInt(this.random, 0, fuzzInvalidEmails().size)]
    }

    companion object {
        @JvmStatic private var unicodeMix: YSArray<String> = "๏̯͡๏斯坦尼斯会文社═╬╬═۩۞۩★★★▀▄▀▄▀▄▀▄۞۞۞இஇஇ®®®√√√๑۩۩๑¤¤¤♂♂♂•••ツツツ●•●•♡♡♡♥♥♥ღღღ♀♀♀♫♫♫₪₪₪øøø♪♪♪ஐஐஐ↕↕↕˜”*°•..•°*”˜ששששש☻☻☻تتت˙˙·.ૐ╬╬╬٭٭٭◘◘◘❖❖❖♣♣♣ύύύ†††☆☆☆ΩΩΩ™①①①♠♠♠█▌○○○☺☺☺ټټﻩﻩﻩ*ﻩ*ﻩ*ﻩ*ﻩ*ﻩﻩﻩ☼☼عتبررفيقة,أناأنتيتلقّىتبحثل,ويحافظأنتيسكت¶¶¶▼▼◄◄►►■«»©©©░░░░░<<>>%$$$###№@@@\"\"\"!~````^^&&???***((()))__---++===///||||░▒▓██▓▒░☀☂♂☻♥╝╝╝ЬЬЬ╕╕╕◘◘◘♣♠♦○○♣♦☻☺000♥♣M♣♣55U╒◙j[♀+♂=♥]™͡๏̯͡๏‡╥█◘(•̪●)◗◖◕◔◓◒▲△▴▵▶▷▸▹►▻▼▽▾▿◀◁◂◃◄◅◆◇◈◉◊○◌◍◎●◐◑◯◮◭◬◫◪◩◨◧■□▢▣▤▥▦▧▨▩▪▫▬▭▮▯▰▱▓▒░▐▏▎▍▌▋▊▉█▂▃▄▅▆▇█▒▓╴╵╶╷╸╹╺╻╼╽╾╿┇┆┅┄┃│╇╆╅╄╃╂╁╀┿┾┽┼┻┺┹┸┷┶┵┴┳┲┱┰┯┮┭┬┫┪┩┨┧┦┥┤┣┢┡┠┟┞┝├┛┚┙┘┗┖┕└┓┒┑┐┏┎┍┌┋┊┉┈┇┆┅╬╫╪╩╨╧╦╥╤╣╢╡╠╟╞╝╜╛╚╙╘╗╖╕╔╓╒║═╏╎╍╌╋╊╉╈༼༽༾༿‣•⑊⑉⑈⑇⑆〭〯〮〬◦〪〫❝❜❛❞₪۩๑¤۞‾□▪▫◊●◦•۝ʻʼʽʾʿˀˁ˂˃˄˅ˆˇˈˉˊˋˌˍˎˏːˑ˒˓˔˕˖˗˘˙˚˛˜˝˞ˠˡˡˢˣˤ̙̘̗̖̔̒̓̑̐̏̎̍̌̋̊̉̈̇̆̅̄̃̂́̀̚̕˩˨˧˦˥̸̡̢̧̨̛̜̝̟̠̣̤̥̦̩̪̫̬̭̮̯̰̱̲̹̺։ְֱֲֳִֵֶַָ֑֖֛֥֦֧֪֚֭֮֒֓֔֕֗֘֙֜֝֞֟֠֡֨֩֫֬֯׃٠٭۝๏།༎༏༓༗༘༙༚༛༜༝༞༟༶༷༵‼‽‖".split("")
        @JvmStatic private var unicodeParentheses: YSArray<String> = "︵︶︷︸︹︺︿﹀︽︾".split("")
        @JvmStatic private var unicodeSmile: YSArray<String> = "ソッヅツゾシジｯﾂｼﾝ〴〳〵〲〱〷〥〤〡ٺقتثةت".split("")
        @JvmStatic private var unicodeZodiac: YSArray<String> = "♈♉♊♋♌♍♎♏♐♑♒♓".split("")
        @JvmStatic private var unicodeOther: YSArray<String> = "✽✾✿❀❁❂❃❄❅❆❇❈❉❊❋♠♡♢♣♤♥♦♧♂♁♀☿♃♄♅♆♇♩♪♫♬♭♮♯☂☃☁☀ﻩ*⁂☚☛☜☝☞☟✌➳❤❣❢ஐஇఞఎയ✁✄✉✔✓☐☑☒✪★☆〠☯☮☭☄☊☣☢☤☬☫☪☨☦☧☥〄〩❦❧♨☸☠✆☎☏‼⌚⌛☡�💩".split("")
        @JvmStatic private var unicodeAll: YSArray<YSArray<String>> = mutableListOf(Fuzzer.unicodeMix, Fuzzer.unicodeParentheses, Fuzzer.unicodeSmile, Fuzzer.unicodeZodiac, Fuzzer.unicodeOther)
    }
}

public enum class AttachmentType {
    ZIP,
}
