// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/mbt-abstractions.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*
import com.yandex.xplat.eventus.common.EventusEvent

public typealias MBTComponentType = String

public interface MBTComponent {
    fun assertMatches(model: App, application: App): Unit
    fun getComponentType(): MBTComponentType
    fun tostring(): String
}

public typealias MBTActionType = String

public interface MBTAction {
    fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean
    fun canBePerformed(model: App): Boolean
    fun perform(model: App, application: App, history: MBTHistory): MBTComponent
    fun getActionType(): MBTActionType
    fun events(): YSArray<EventusEvent>
    fun tostring(): String
}

public interface MBTHistory {
    val currentComponent: MBTComponent
    val previousDifferentComponent: MBTComponent?
    val allPreviousComponents: YSArray<MBTComponent>
}

public typealias FeatureID = String

public interface App {
    var supportedFeatures: YSArray<FeatureID>
    fun getFeature(feature: FeatureID): Any
    fun dump(model: App): String
}

public open class Feature<T>(val name: FeatureID, val description: String) {
    open fun included(supportedFeatures: YSArray<FeatureID>): Boolean {
        return supportedFeatures.contains(this.name)
    }

    open fun includedAll(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return this.included(modelFeatures) && this.included(applicationFeatures)
    }

    open fun forceCast(app: App): T {
        val t = this.castIfSupported(app)
        if (t == null) {
            throw Error("Feature '${this.name}' is unsupported!")
        }
        return t!!
    }

    open fun castIfSupported(app: App): T? {
        if (!app.supportedFeatures.contains(this.name)) {
            return null
        }
        return this.cast(app.getFeature(this.name))
    }

    open fun cast(obj: Any): T {
        return obj as T
    }

    open fun performIfSupported(app: App, action: (T) -> Unit): Unit {
        val featured: T? = this.castIfSupported(app)
        if (featured != null) {
            action(featured)
        }
    }

}

public open class FeatureRegistry() {
    private var registry: YSMap<FeatureID, Any> = mutableMapOf()
    open fun <T> register(feature: Feature<T>, implementation: T): FeatureRegistry {
        this.registry.set(feature.name, castToAny(implementation))
        return this
    }

    open fun `get`(feature: FeatureID): Any {
        val result = undefinedToNull(this.registry.get(feature))
        if (result == null) {
            throw Error("Фича ${feature} не зарегестрирована. Реализация фичи должна быть в getFeature")
        }
        return result!!
    }

}

