// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/state-machine.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.Logger
import com.yandex.xplat.common.YSArray

public open class StateMachine(private var model: App, private var application: App, private var walkStrategy: WalkStrategy, private var logger: Logger) {
    open fun go(start: MBTComponent, limit: Int? = null): Boolean {
        var currentComponent: MBTComponent? = start
        val history = HistoryBuilder(start)
        var i: Int = 0
        while (currentComponent != null) {
            this.logger.info("Step №${i}:")
            currentComponent = this.step(history)
            if (currentComponent != null) {
                history.next(currentComponent!!)
            }
            i += 1
            if (i == limit) {
                break
            }
        }
        return i > 1
    }

    open fun step(history: MBTHistory): MBTComponent? {
        val current = history.currentComponent
        val action = this.walkStrategy.nextAction(this.model, this.application.supportedFeatures, current)
        if (action == null) {
            this.logger.info("No possible actions available")
            return null
        }
        this.logAction(action, "==========")
        if (!action.supported(this.model.supportedFeatures, this.application.supportedFeatures)) {
            throw Error("Не могу совершить действие ${action.tostring()}, поскольку модель или приложение не поддерживают его")
        }
        var canPerform: Boolean
        try {
            canPerform = action.canBePerformed(this.model)
        } catch (e: RuntimeException) {
            throw Error("Не получается проверить выполнимость экшена ${action.tostring()}, что-то не так с моделью")
        }
        if (!canPerform) {
            throw Error("Can't perform ${action.tostring()}, because it can't be performed in current model state")
        }
        this.logAction(action, "Performing action ${action.tostring()} on current component ${current.tostring()}")
        val nextComponent = action.perform(this.model, this.application, history)
        this.logAction(action, "Action ${action.tostring()} on component ${current.tostring()} performed, new component is ${nextComponent.tostring()}")
        this.logAction(action, "==========\n")
        return nextComponent
    }

    private fun logAction(action: MBTAction, message: String): Unit {
        if (!fakeActions().contains(action.getActionType())) {
            this.logger.info(message)
        }
    }

}

public open class HistoryBuilder(override var currentComponent: MBTComponent): MBTHistory {
    override var previousDifferentComponent: MBTComponent? = null
    override var allPreviousComponents: YSArray<MBTComponent> = mutableListOf()
    open fun next(component: MBTComponent): HistoryBuilder {
        if (this.currentComponent.tostring() != component.tostring()) {
            this.allPreviousComponents.add(this.currentComponent)
            this.previousDifferentComponent = this.currentComponent
            this.currentComponent = component
        }
        return this
    }

}

public interface WalkStrategy {
    fun nextAction(model: App, applicationFeatures: YSArray<FeatureID>, component: MBTComponent): MBTAction?
}

