// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/test/base-user-behaviour-test.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.Logger
import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSError

public abstract class BaseUserBehaviourTest<T>(description: String, protected val startComponent: MBTComponent, protected val pathLength: Int, protected val logger: Logger, protected val seed: Int): MBTTest<T>(description, mutableListOf(TestSuite.Random)) {
    open override fun scenario(accounts: YSArray<UserAccount>, model: AppModel?, supportedFeatures: YSArray<FeatureID>): TestPlan {
        if (model == null) {
            return TestPlan.empty()
        }
        val random = PseudoRandomProvider(this.seed)
        val behaviour = this.getUserBehaviour(accounts)
        val walkStrategy = UserBehaviourWalkStrategy(behaviour, RandomActionChooser(random), this.pathLength)
        var applicationModel = model.copy()
        applicationModel.supportedFeatures = supportedFeatures
        val stateMachine = StateMachine(model, applicationModel, walkStrategy, this.logger)
        try {
            stateMachine.go(this.startComponent)
        } catch (e: RuntimeException) {
            if (e is YSError) {
                fail((e as YSError).message)
            } else {
                throw Error("Only YSError supported!")
            }
        }
        return TestPlan.empty().thenChain(walkStrategy.history)
    }

    abstract override fun requiredAccounts(): YSArray<AccountType2>
    abstract override fun prepareAccounts(preparers: YSArray<T>): Unit
    abstract fun getUserBehaviour(accounts: YSArray<UserAccount>): UserBehaviour
}

public abstract class FullCoverageBaseTest<T>(description: String, private var startComponent: MBTComponent, private var logger: Logger): MBTTest<T>(description, mutableListOf(TestSuite.FullCoverage)) {
    open override fun scenario(accounts: YSArray<UserAccount>, model: AppModel?, supportedFeatures: YSArray<FeatureID>): TestPlan {
        if (model == null) {
            return TestPlan.empty()
        }
        val behaviour = this.getUserBehaviour(accounts)
        val limits = this.getActionLimits()
        val runner = MultiRunner(this.startComponent, behaviour, limits, supportedFeatures, this.logger)
        val path = runner.preparePath(model)
        val pathLength = path.size
        this.logger.info("Optimal path length: ${pathLength}")
        return TestPlan.empty().thenChain(path)
    }

    abstract override fun requiredAccounts(): YSArray<AccountType2>
    abstract override fun prepareAccounts(builders: YSArray<T>): Unit
    abstract fun getUserBehaviour(userAccounts: YSArray<UserAccount>): UserBehaviour
    abstract fun getActionLimits(): ActionLimitsStrategy
}

