// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/test/mbt-test.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public enum class AccountType2(val value: String) {
    Yandex("YANDEX"),
    YandexTest("YANDEX_TEST"),
    YandexTeam("YANDEX_TEAM"),
    Yahoo("YAHOO"),
    Google("GMAIL"),
    Mail("MAIL"),
    Hotmail("HOTMAIL"),
    Rambler("RAMBLER"),
    Outlook("OUTLOOK"),
    Other("OTHER"),
    ;
    override fun toString(): String = value
}
public enum class MBTPlatform {
    MobileAPI,
    Android,
    IOS,
    Desktop,
}
public enum class TestSuite(val value: String) {
    Fixed("Fixed_tests"),
    Random("Random_tests"),
    FullCoverage("Full_coverage"),
    ;
    override fun toString(): String = value
}
public abstract class MBTTest<T> protected constructor(val description: String, val suites: YSArray<TestSuite> = mutableListOf(TestSuite.Fixed)) {
    open fun setupSettings(settings: TestSettings): Unit {
    }

    abstract fun requiredAccounts(): YSArray<AccountType2>
    abstract fun prepareAccounts(preparers: YSArray<T>): Unit
    abstract fun scenario(accounts: YSArray<UserAccount>, model: AppModel?, supportedFeatures: YSArray<FeatureID>): TestPlan
}

public open class TestSettings(private var currentPlatform: MBTPlatform) {
    private var testCaseIds: YSMap<MBTPlatform, Int> = mutableMapOf<MBTPlatform, Int>()
    private var ignoredPlatforms: YSSet<MBTPlatform> = YSSet()
    open fun setTestCaseId(platform: MBTPlatform, id: Int): TestSettings {
        this.testCaseIds.set(platform, id)
        return this
    }

    open fun androidCase(id: Int): TestSettings {
        return this.setTestCaseId(MBTPlatform.Android, id)
    }

    open fun iosCase(id: Int): TestSettings {
        return this.setTestCaseId(MBTPlatform.IOS, id)
    }

    open fun commonCase(id: Int): TestSettings {
        return this.iosCase(id).androidCase(id)
    }

    open fun ignoreOn(platform: MBTPlatform): TestSettings {
        this.ignoredPlatforms.add(platform)
        return this
    }

    open fun isIgnored(): Boolean {
        return this.ignoredPlatforms.has(this.currentPlatform)
    }

    open fun getCaseIDForPlatform(platform: MBTPlatform): Int {
        if (undefinedToNull(this.testCaseIds.get(platform)) != null) {
            return this.testCaseIds.`get`(platform)!!
        } else {
            return 0
        }
    }

}

