// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/test/tests-registry.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public enum class TestMandatory {
    REQUIRED,
    OPTIONAL,
    IGNORED,
    DEBUG,
}
public open class TestsRegistry<T> {
    private val tests: YSMap<String, MBTTest<T>> = mutableMapOf<String, MBTTest<T>>()
    private val testMandatories: YSMap<String, TestMandatory> = mutableMapOf<String, TestMandatory>()
    private val passedTests: YSSet<String> = YSSet<String>()
    private val failedTests: YSMap<String, Int> = mutableMapOf<String, Int>()
    private var testResults: ArrayJSONItem = ArrayJSONItem()
    private var ignoreLogs: YSSet<String> = YSSet<String>()
    private var ignoreLogEvents: YSSet<String> = YSSet<String>()
    private var bucketIndex: Int = 0
    private var bucketsTotal: Int = 1
    private var retriesCount: Int = 0
    open fun optional(test: MBTTest<T>): TestsRegistry<T> {
        return this.register(test, TestMandatory.OPTIONAL)
    }

    open fun optionalAll(tests: YSArray<MBTTest<T>>): TestsRegistry<T> {
        for (test in tests) {
            this.optional(test)
        }
        return this
    }

    open fun required(test: MBTTest<T>): TestsRegistry<T> {
        return this.register(test, TestMandatory.REQUIRED)
    }

    open fun requiredAll(tests: YSArray<MBTTest<T>>): TestsRegistry<T> {
        for (test in tests) {
            this.required(test)
        }
        return this
    }

    open fun debug(test: MBTTest<T>): TestsRegistry<T> {
        return this.register(test, TestMandatory.DEBUG)
    }

    open fun ignore(test: MBTTest<T>): TestsRegistry<T> {
        return this.register(test, TestMandatory.IGNORED)
    }

    open fun only(required: Boolean): TestsRegistry<T> {
        val testsToForget = this.getTests(if (required) TestMandatory.OPTIONAL else TestMandatory.REQUIRED)
        for (test in testsToForget) {
            this.tests.delete(test.description)
        }
        return this
    }

    open fun onlyTestsWithCaseIds(include: Boolean, ids: YSArray<Int>, platform: MBTPlatform): TestsRegistry<T> {
        val testsToForget = if (include) this.getTestsExcludingTestsWithCaseIds(ids, platform) else this.getTestsByCaseIds(ids, platform)
        for (test in testsToForget) {
            this.tests.delete(test.description)
        }
        return this
    }

    open fun bucket(bucketIndex: Int, totalBuckets: Int): TestsRegistry<T> {
        this.bucketIndex = bucketIndex
        this.bucketsTotal = totalBuckets
        return this
    }

    open fun ignoreLogsTesting(test: MBTTest<T>): TestsRegistry<T> {
        this.ignoreLogs.add(test.description)
        return this
    }

    open fun ignoreLogEvent(eventName: String): TestsRegistry<T> {
        this.ignoreLogEvents.add(eventName)
        return this
    }

    open fun retries(count: Int): TestsRegistry<T> {
        this.retriesCount = count
        return this
    }

    open fun getTestsPossibleToRun(platform: MBTPlatform, modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): YSArray<MBTTest<T>> {
        val result: YSArray<MBTTest<T>> = mutableListOf()
        val testsToDebug = this.getTests(TestMandatory.DEBUG)
        if (testsToDebug.size > 0) {
            for (test in testsToDebug) {
                for (`_` in (0 until 1 + this.retriesCount step 1)) {
                    result.add(test)
                }
            }
            return result
        }
        for (test in this.getTestBucket(platform, modelFeatures, applicationFeatures)) {
            for (`_` in (0 until 1 + this.retriesCount step 1)) {
                result.add(test)
            }
        }
        return result
    }

    open fun passed(test: MBTTest<T>): Unit {
        this.passedTests.add(test.description)
    }

    open fun failed(test: MBTTest<T>): Unit {
        if (this.failedTests.has(test.description)) {
            this.failedTests.set(test.description, this.failedTests.`get`(test.description)!! + 1)
        } else {
            this.failedTests.set(test.description, 1)
        }
        if (this.passedTests.has(test.description)) {
            this.passedTests.delete(test.description)
        }
    }

    open fun isPassed(test: MBTTest<T>): Boolean {
        return this.passedTests.has(test.description)
    }

    open fun isNeedTryMore(test: MBTTest<T>): Boolean {
        val failedNum = this.failedTests.get(test.description)
        if (undefinedToNull(failedNum) != null) {
            return this.failedTests.`get`(test.description)!! <= this.retriesCount
        }
        return true
    }

    open fun isTestEnabled(test: MBTTest<T>, platform: MBTPlatform, modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        if (this.isTestToDebug(test)) {
            return true
        }
        if (this.isIgnored(test)) {
            return false
        }
        val fakeAccounts = test.requiredAccounts().map( {
            _ ->
            UserAccount("", "")
        })
        val unsupportedActions = test.scenario(fakeAccounts, null, applicationFeatures).unsupportedActions(modelFeatures, applicationFeatures)
        if (unsupportedActions.size > 0) {
            var s = ""
            for (action in unsupportedActions) {
                s += ";${action.tostring()}"
            }
            Log.info("'${test.description}': application should support actions: ${s}")
        }
        val settings = this.getTestSettings(test, platform)
        val ignored = settings.isIgnored()
        if (ignored) {
            Log.info("'${test.description}': помечен как нерабочий. " + "Пожалуйста, почините это - тесты должны включаться/отключаться через поддержку фичей")
        }
        return unsupportedActions.size == 0 && !ignored
    }

    open fun isTestToDebug(test: MBTTest<T>): Boolean {
        return this.testMandatories.get(test.description) == TestMandatory.DEBUG
    }

    open fun isIgnored(test: MBTTest<T>): Boolean {
        return this.testMandatories.get(test.description) == TestMandatory.IGNORED
    }

    open fun isIgnoredLogsTesting(test: MBTTest<T>): Boolean {
        return this.ignoreLogs.has(test.description)
    }

    open fun isIgnoredLogEvent(eventName: String): Boolean {
        return this.ignoreLogEvents.has(eventName)
    }

    private fun getTestBucket(platform: MBTPlatform, modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): YSArray<MBTTest<T>> {
        val ignoredTests: YSArray<MBTTest<T>> = valuesArray(this.tests).filter( {
            item ->
            !this.isTestEnabled(item, platform, modelFeatures, applicationFeatures)
        }).sort( {
            l, r ->
            (if (l.description < r.description) -1 else if (l.description == r.description) 0 else 1)
        })
        val testsBucket: YSArray<MBTTest<T>> = valuesArray(this.tests).filter( {
            item ->
            !ignoredTests.map( {
                test ->
                test.description
            }).contains(item.description)
        }).sort( {
            l, r ->
            (if (l.description < r.description) -1 else if (l.description == r.description) 0 else 1)
        })
        var runTestsCount: Int = testsBucket.size
        var ignoredTestsCount: Int = ignoredTests.size
        Log.info("${runTestsCount} tests total to run, ${ignoredTestsCount} tests total to ignore, ${this.bucketsTotal} buckets")
        val ignoredBucketSliceIndexes = getSliceIndexesForBuckets(ignoredTestsCount, this.bucketsTotal)
        val bucketSliceIndexes = getSliceIndexesForBuckets(runTestsCount, this.bucketsTotal)
        val testsToRun = testsBucket.slice(bucketSliceIndexes[this.bucketIndex], bucketSliceIndexes[this.bucketIndex + 1])
        val testsToIgnore = ignoredTests.slice(ignoredBucketSliceIndexes[this.bucketIndex], ignoredBucketSliceIndexes[this.bucketIndex + 1])
        runTestsCount = testsToRun.size
        ignoredTestsCount = testsToIgnore.size
        Log.info("${testsToRun}")
        Log.info("${runTestsCount} tests to run, ${ignoredTestsCount} test to ignore in current bucket")
        return testsToRun.concat(testsToIgnore)
    }

    open fun getTestSettings(test: MBTTest<T>, platform: MBTPlatform): TestSettings {
        val settings = TestSettings(platform)
        test.setupSettings(settings)
        return settings
    }

    private fun register(test: MBTTest<T>, mandatory: TestMandatory): TestsRegistry<T> {
        this.tests.set(test.description, test)
        this.testMandatories.set(test.description, mandatory)
        return this
    }

    private fun getTests(mandatory: TestMandatory): YSArray<MBTTest<T>> {
        val tests: YSArray<MBTTest<T>> = mutableListOf()
        for (test in this.tests.values()) {
            if (mandatory == this.testMandatories.get(test.description)) {
                tests.add(test)
            }
        }
        return tests
    }

    private fun getTestsExcludingTestsWithCaseIds(ids: YSArray<Int>, platform: MBTPlatform): YSArray<MBTTest<T>> {
        val tests: YSArray<MBTTest<T>> = mutableListOf()
        for (test in this.tests.values()) {
            if (!ids.contains(this.getTestSettings(test, platform).getCaseIDForPlatform(platform))) {
                tests.add(test)
            }
        }
        return tests
    }

    private fun getTestsByCaseIds(ids: YSArray<Int>, platform: MBTPlatform): YSArray<MBTTest<T>> {
        val tests: YSArray<MBTTest<T>> = mutableListOf()
        for (test in this.tests.values()) {
            if (ids.contains(this.getTestSettings(test, platform).getCaseIDForPlatform(platform))) {
                tests.add(test)
            }
        }
        return tests
    }

    open fun setTestResult(result: MapJSONItem): Unit {
        this.testResults.add(result)
    }

    open fun getTestResults(): ArrayJSONItem {
        return this.testResults
    }

    open fun clearTestResults(): Unit {
        this.testResults = ArrayJSONItem()
    }

}

