// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/dfs-walk-strategy.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class DfsWalkStrategy(private var hashProvider: HashProvider, private var actionLimits: ActionLimitsStrategy): ActionChooser {
    var graph: Graph<MBTAction> = Graph()
    var stack: Stack<Int> = Stack<Int>()
    var stateStack: Stack<AppModel> = Stack<AppModel>()
    var componentStack: Stack<MBTComponent> = Stack<MBTComponent>()
    var hashStack: Stack<Long> = Stack<Long>()
    var previousVertex: Long = int64(-1)
    private var used: YSSet<Long> = YSSet<Long>()
    private var actionStack: Stack<MBTAction> = Stack<MBTAction>()
    private var numberOfEdge: Int = -1
    open override fun choose(possibleActions: YSArray<MBTAction>, component: MBTComponent): MBTAction? {
        val currentHash: Long = this.hashProvider.getHash()
        this.stateStack.push(this.hashProvider.getModelCopy()!!)
        this.hashStack.push(currentHash)
        this.componentStack.push(component)
        if (this.numberOfEdge >= 0) {
            this.graph.addEdgeVV(this.previousVertex, currentHash, this.actionStack.top())
        }
        if (this.used.has(currentHash)) {
            this.stepBack()
            return null
        }
        this.used.add(currentHash)
        this.graph.addVertex(currentHash)
        val actionIndex = this.graph.getDegreeV(currentHash)
        if (possibleActions.size <= actionIndex || !this.actionLimits.check(this.actionStack)) {
            this.stepBack()
            return null
        }
        this.previousVertex = currentHash
        this.numberOfEdge = actionIndex
        this.stack.push(this.numberOfEdge)
        this.actionStack.push(possibleActions[this.numberOfEdge])
        return possibleActions[this.numberOfEdge]
    }

    private fun stepBack(): Unit {
        this.stateStack.pop()
        this.hashStack.pop()
        this.componentStack.pop()
        this.stack.pop()
        this.actionStack.pop()
        this.used.delete(this.previousVertex)
        this.numberOfEdge = -1
    }

}

public open class MultiRunner(private var component: MBTComponent, private var behaviour: UserBehaviour, actionLimits: ActionLimitsStrategy, private var supportedFeatures: YSArray<FeatureID>, private var logger: Logger) {
    val walkStrategyWithState: DfsWalkStrategy
    private val hashProvider: HashProvider
    init {
        this.hashProvider = HashProvider()
        this.walkStrategyWithState = DfsWalkStrategy(this.hashProvider, actionLimits)
    }
    open fun preparePath(model: AppModel): YSArray<MBTAction> {
        var model2 = model.copy()
        model2.supportedFeatures = this.supportedFeatures
        var model3 = model.copy()
        model3.supportedFeatures = this.supportedFeatures
        this.logger.info("DFS started")
        while (true) {
            this.hashProvider.setModel(model2)
            val modelVsModel = StateMachine(model2, model3, UserBehaviourWalkStrategy(this.behaviour, this.walkStrategyWithState), this.logger)
            try {
                modelVsModel.go(this.component)
            } catch (e: RuntimeException) {
                if (e is YSError) {
                    fail((e as YSError).message)
                } else {
                    throw Error("Only YSError supported!")
                }
            }
            if (this.walkStrategyWithState.stateStack.size() == 0) {
                break
            }
            this.component = this.walkStrategyWithState.componentStack.top()
            model2 = this.walkStrategyWithState.stateStack.top().copy()
            model3 = this.walkStrategyWithState.stateStack.top().copy()
            this.walkStrategyWithState.stateStack.pop()
            this.walkStrategyWithState.hashStack.pop()
            this.walkStrategyWithState.componentStack.pop()
            if (this.walkStrategyWithState.hashStack.size() > 0) {
                this.walkStrategyWithState.previousVertex = this.walkStrategyWithState.hashStack.top()
            }
        }
        this.logger.info("DFS finished\n")
        this.logger.info("Count of vertexes = ${this.walkStrategyWithState.graph.size()}")
        this.logger.info("Count of edges = ${this.walkStrategyWithState.graph.countOfEdges()}")
        return LongestPathAlgo.getLongestPath(this.walkStrategyWithState.graph, this.logger)
    }

}

public open class HashProvider() {
    private var model: AppModel? = null
    open fun setModel(model: AppModel): Unit {
        this.model = model
    }

    open fun getHash(): Long {
        if (this.model != null) {
            return this.model!!.getCurrentStateHash()
        }
        return int64(-1)
    }

    open fun getModelCopy(): AppModel? {
        val modelSnapshot = this.model
        if (modelSnapshot != null) {
            return modelSnapshot.copy()
        }
        return null
    }

}

