// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/fixed-scenario-strategy.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*
import com.yandex.xplat.eventus.common.EventusEvent

public open class FixedScenarioStrategy(private var scenario: YSArray<MBTAction>): WalkStrategy {
    private var position: Int = 0
    open override fun nextAction(_model: App, _applicationFeatures: YSArray<FeatureID>, _component: MBTComponent): MBTAction? {
        if (this.position == this.scenario.size) {
            return null
        }
        val action = this.scenario[this.position]
        this.position += 1
        return action
    }

}

public open class TestPlan private constructor() {
    private var actions: YSArray<MBTAction> = mutableListOf()
    open fun then(action: MBTAction): TestPlan {
        return this.thenChain(mutableListOf(action))
    }

    open fun thenChain(actions: YSArray<MBTAction>): TestPlan {
        for (action in actions) {
            this.actions.add(action)
            this.actions.add(DebugDumpAction())
        }
        return this
    }

    open fun unsupportedActions(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): YSArray<MBTAction> {
        val result: YSArray<MBTAction> = mutableListOf()
        for (action in this.actions) {
            if (!action.supported(modelFeatures, applicationFeatures)) {
                result.add(action)
            }
        }
        return result
    }

    open fun getExpectedEvents(): YSArray<EventusEvent> {
        val result: YSArray<EventusEvent> = mutableListOf()
        for (action in this.actions) {
            for (event in action.events()) {
                result.add(event)
            }
        }
        return result
    }

    open fun build(accountLocks: YSArray<UserLock>?, assertionsEnabled: Boolean = true): WalkStrategy {
        val actions: YSArray<MBTAction> = mutableListOf()
        for (action in this.actions) {
            if (assertionsEnabled || AssertAction.type != action.getActionType()) {
                actions.add(action)
            }
            if (accountLocks != null) {
                accountLocks!!.forEach( {
                    accLock ->
                    actions.add(PingAccountLockAction(accLock))
                })
            }
        }
        actions.add(AssertAction())
        return FixedScenarioStrategy(actions)
    }

    open fun tostring(): String {
        var s = "PATH\n"
        for (action in this.actions) {
            s += action.tostring() + "\n"
        }
        return s + "END\n"
    }

    companion object {
        @JvmStatic
        open fun empty(): TestPlan {
            return TestPlan()
        }

    }
}

public open class TestopithecusTestRunner<T: AccountDataPreparer>(private var platform: MBTPlatform, private val test: MBTTest<T>, private val testsRegistry: TestsRegistry<T>, private var preparerProvider: AccountDataPreparerProvider<T>, applicationCredentials: OAuthApplicationCredentialsRegistry, private var network: SyncNetwork, private var jsonSerializer: JSONSerializer, private var logger: Logger, private var assertionsEnabled: Boolean = true, private var userTags: YSArray<String> = mutableListOf(), var statToken: String = "", var testPalmToken: String = "", private var tusConsumer: String = "testopithecus") {
    val oauthService: OauthService
    var reporter: ReportIntegration?
    private var locks: YSArray<UserLock> = mutableListOf()
    private var modelProvider: AppModelProvider? = null
    private var testPlan: TestPlan? = null
    private var userAccountsMap: UserServiceEnsemble
    private var startTime: Long
    init {
        val userService = UserService(network, jsonSerializer, logger)
        this.userAccountsMap = UserServiceEnsemble(userService, this.test.requiredAccounts(), this.tusConsumer, this.userTags)
        this.oauthService = OauthService(applicationCredentials, network, jsonSerializer)
        this.startTime = int64(0)
        this.reporter = null
    }
    open fun isEnabled(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return this.testsRegistry.isTestEnabled(this.test, this.platform, modelFeatures, applicationFeatures)
    }

    open fun isPassed(): Boolean {
        val passed = this.testsRegistry.isPassed(this.test)
        if (passed) {
            this.logger.info("Тест '${this.test.description}' уже пройден, поэтому сейчас он пройден не будет")
        }
        return passed
    }

    open fun isNeedTryMore(): Boolean {
        val isNeedTryMore = this.testsRegistry.isNeedTryMore(this.test)
        if (!isNeedTryMore) {
            this.logger.info("Тест '${this.test.description}' упал слишком много раз, ретраев не осталось")
        }
        return isNeedTryMore
    }

    open fun failed(): Unit {
        this.testsRegistry.failed(this.test)
        var isIntermediate = false
        if (this.isNeedTryMore()) {
            isIntermediate = true
        }
        this.setTestResult(false, true, false, isIntermediate)
    }

    open fun lockAndPrepareAccountData(): XPromise<YSArray<OAuthUserAccount>> {
        this.logger.info("Try to prepare account data for test ${this.test.description}")
        val min10 = int64(10 * 60 * 1000)
        val min2 = int64(2 * 60 * 1000)
        val requiredAccounts = this.test.requiredAccounts()
        val accounts: YSArray<OAuthUserAccount> = mutableListOf()
        for (i in (0 until requiredAccounts.size step 1)) {
            val type = requiredAccounts[i]
            val lock = this.userAccountsMap.getAccountByType(type).tryAcquire(min10, min2)
            if (lock == null) {
                this.releaseLocks()
                return reject(LockAcquireError(type))
            }
            this.locks.add(lock!!)
        }
        val accountDataPreparers: YSArray<T> = mutableListOf()
        for (accountIndex in (0 until this.locks.size step 1)) {
            val account = this.locks[accountIndex].lockedAccount()
            val preparer = this.preparerProvider.provide(account, requiredAccounts[accountIndex])
            accountDataPreparers.add(preparer)
        }
        this.test.prepareAccounts(accountDataPreparers)
        val promises: YSArray<XPromise<Unit>> = mutableListOf()
        for (i in (0 until this.locks.size step 1)) {
            val account = this.locks[i].lockedAccount()
            val accountType = requiredAccounts[i]
            val token = this.oauthService.getToken(account, accountType)
            val oauthAccount = OAuthUserAccount(account, token, accountType)
            accounts.add(oauthAccount)
            val preparePromise = accountDataPreparers[i].prepare(oauthAccount)
            promises.add(preparePromise)
        }
        this.modelProvider = this.preparerProvider.provideModelDownloader(accountDataPreparers, accounts)
        return all(promises).then( {
            _ ->
            accounts
        })
    }

    open fun runTest(accounts: YSArray<OAuthUserAccount>, start: MBTComponent, application: App?): Unit {
        this.logger.info("Test ${this.test.description} started")
        this.startTime = int64(YSDate().getTime())
        this.setTestResult(true, false, false, false)
        this.setInfoForReporter()
        val modelProvider = requireNonNull(this.modelProvider, "Should lockAndPrepareAccountData before runTest!")
        val model = modelProvider.takeAppModel()
        val model2 = model.copy()
        val model3 = model.copy()
        val supportedFeatures = (if (application != null) application!! else model).supportedFeatures
        val testPlan = this.test.scenario(accounts.map( {
            a ->
            a.account
        }), model, supportedFeatures)
        this.testPlan = testPlan
        this.logger.info(testPlan.tostring())
        val walkStrategyWithState1 = testPlan.build(null, true)
        val walkStrategyWithState2 = testPlan.build(this.locks, this.assertionsEnabled)
        this.logger.info("Model vs Model testing started")
        val modelVsModel = StateMachine(model, model2, walkStrategyWithState1, this.logger)
        modelVsModel.go(start)
        this.logger.info("Model vs Model testing finished")
        this.logger.info("\n")
        if (application == null) {
            return
        }
        this.logger.info("Model vs Application testing started")
        val modelVsApplication = StateMachine(model3, application, walkStrategyWithState2, this.logger)
        modelVsApplication.go(start)
        this.logger.info("Model vs Application testing finished")
        this.logger.info("\n")
        this.logger.info("Test ${this.test.description} finished")
        this.testsRegistry.passed(this.test)
        this.setTestResult(false, false, false, false)
    }

    open fun validateLogs(logs: String): Unit {
        val testPlan = requireNonNull(this.testPlan, "Запустите тест runTest сначала!")
        val actualEvents: YSArray<EventusEvent> = mutableListOf()
        val lines = logs.split("\n")
        for (line in lines) {
            if (line.length > 0) {
                val parser = CrossPlatformLogsParser(this.jsonSerializer)
                val event = parser.parse(line)
                if (!this.testsRegistry.isIgnoredLogEvent(event.name)) {
                    actualEvents.add(event)
                }
            }
        }
        if (this.testsRegistry.isIgnoredLogsTesting(this.test)) {
            this.logger.info("TODO: пожалуйста, почините логирование для теста '${this.test.description}'")
            return
        }
        val expectedEvents = testPlan.getExpectedEvents()
        val expectedEventsNames = expectedEvents.map( {
            event ->
            event.name
        })
        val actualEventsNames = actualEvents.map( {
            event ->
            event.name
        })
        val logMessage = "\nОжидаемые события '${expectedEventsNames}'\nПолученные события '${actualEventsNames}'"
        this.logger.info(logMessage)
        for (i in (0 until maxInt32(actualEvents.size, expectedEvents.size) step 1)) {
            if (i >= actualEvents.size) {
                throw YSError("Ожидалось событие '${expectedEvents[i].name}', но событий больше нет.'${logMessage}'")
            }
            val actual = actualEvents[i]
            if (i >= expectedEvents.size) {
                throw YSError("Вижу событие '${actual.name}', но больше событий не должно быть.'${logMessage}'")
            }
            val expected = expectedEvents[i]
            this.logger.info("Событие №${i}: согласно действиям в сценарии должно быть '${expected.name}', в логах '${actual.name}'.'${logMessage}'")
            assertStringEquals(expected.name, actual.name, "Разные события на месте #${i}.'${logMessage}'\n")
        }
    }

    open fun finish(): Unit {
        this.releaseLocks()
        this.logger.info("Тест '${this.test.description}' закончился")
    }

    private fun releaseLocks(): Unit {
        if (this.locks.size != 0) {
            this.locks.forEach(__LBL__FixedScenarioStrategy_1@ {
                lock ->
                if (lock != null) {
                    lock.release()
                }
            })
            this.locks = mutableListOf()
            this.logger.info("Locks for test ${this.test.description} released")
        }
    }

    private fun setTestResult(isStarted: Boolean, isFailed: Boolean, isSkipped: Boolean, isIntermediate: Boolean): Unit {
        val execTime: Int = int64ToInt32((int64(YSDate().getTime()) - this.startTime) / int64(1000))
        val caseId: Int = this.testsRegistry.getTestSettings(this.test, this.platform).getCaseIDForPlatform(this.platform)
        val year = YSDate().getFullYear()
        val month = YSDate().getMonth() + 1
        val day = YSDate().getDate()
        val hours = YSDate().getHours()
        val minutes = YSDate().getMinutes()
        val seconds = YSDate().getSeconds()
        var project = ""
        when (this.platform) {
            MBTPlatform.MobileAPI -> {
                project = "mob_api"
            }
            MBTPlatform.Desktop -> {
                project = "desktop"
            }
            MBTPlatform.Android -> {
                project = "android"
            }
            MBTPlatform.IOS -> {
                project = "ios"
            }
        }
        this.testsRegistry.setTestResult(MapJSONItem().putString("fielddate", "${year}-${month}-${day} ${hours}:${minutes}:${seconds}").putString("project", project).putInt32("id", caseId).putString("test_name", this.test.description).putInt32("is_started", if (isStarted) 1 else 0).putInt32("is_passed", if (this.isPassed()) 1 else 0).putInt32("is_failed", if (isFailed) 1 else 0).putInt32("is_skipped", if (isSkipped) 1 else 0).putInt32("is_intermediate", if (isIntermediate) 1 else 0).putString("execution_time", if (execTime > 5) int32ToString(execTime) else ""))
    }

    open fun sendTestsResults(testNameWhenSend: String): Unit {
        if (this.statToken == "") {
            this.logger.info("No token for stat! No statistics will be sent")
            return
        }
        if (testNameWhenSend == this.test.description) {
            this.logger.info(this.network.syncExecuteWithRetries(2, "https://upload.stat.yandex-team.ru/", StatNetworkRequest(this.testsRegistry.getTestResults()), this.statToken))
            this.testsRegistry.clearTestResults()
        } else {
            this.logger.info("Тест не последний в бакете, статистику не отправляем")
        }
    }

    open fun setInfoForReporter(): Unit {
        if (this.reporter != null) {
            this.reporter!!.addTestpalmId(this.testsRegistry.getTestSettings(this.test, this.platform).getCaseIDForPlatform(this.platform))
            val indexOfFeatureEnd: Int = this.test.description.indexOf(".")
            if (indexOfFeatureEnd > 0) {
                this.reporter!!.addFeatureName(this.test.description.substring(0, indexOfFeatureEnd))
            }
        }
    }

}

public interface AppModel: App {
    fun copy(): AppModel
    fun getCurrentStateHash(): Long
}

public interface AppModelProvider {
    fun takeAppModel(): AppModel
}

public open class LockAcquireError(accountType: AccountType2): YSError("Can\'t acquire lock for ${accountType}!") {
}

