// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/user-behaviour-walk-strategy.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.filter

public open class UserBehaviourWalkStrategy(private var behaviour: UserBehaviour, private var chooser: ActionChooser = RandomActionChooser(), private var stepsLimit: Int? = null): WalkStrategy {
    val history: YSArray<MBTAction> = mutableListOf()
    private var currentStep: Int = 0
    open override fun nextAction(model: App, applicationFeatures: YSArray<FeatureID>, component: MBTComponent): MBTAction? {
        val possibleActions = this.behaviour.getActions(model, component).filter( {
            mbtAction ->
            mbtAction.supported(model.supportedFeatures, applicationFeatures)
        }).filter(__LBL__UserBehaviourWalkStrategy_1@ {
            mbtAction ->
            try {
                return@__LBL__UserBehaviourWalkStrategy_1 mbtAction.canBePerformed(model)
            } catch (e: RuntimeException) {
                throw Error("Не получается проверить выполнимость экшена ${mbtAction.tostring()}, что-то не так с моделью")
            }
        })
        if (possibleActions.size == 0) {
            return null
        }
        if (this.currentStep == this.stepsLimit) {
            return null
        }
        val action = this.chooser.choose(possibleActions, component)
        if (action == null) {
            return null
        }
        this.history.add(action)
        this.currentStep += 1
        return action
    }

}

public interface ActionChooser {
    fun choose(actions: YSArray<MBTAction>, component: MBTComponent): MBTAction?
}

public open class RandomActionChooser(private var random: RandomProvider = PseudoRandomProvider.INSTANCE): ActionChooser {
    open override fun choose(actions: YSArray<MBTAction>, _component: MBTComponent): MBTAction? {
        if (actions.size == 0) {
            return null
        }
        val order = this.random.generate(actions.size)
        return actions[order]
    }

}

