// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/behaviour/user-behaviour.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class UserBehaviour() {
    private var actionProviders: YSMap<MBTComponentType, MBTComponentActions> = mutableMapOf<MBTComponentType, MBTComponentActions>()
    open fun setActionProvider(type: MBTComponentType, actionProvider: MBTComponentActions): UserBehaviour {
        this.actionProviders.set(type, actionProvider)
        return this
    }

    open fun setActions(type: MBTComponentType, actions: YSArray<MBTAction>): UserBehaviour {
        this.setActionProvider(type, ListActions(actions))
        return this
    }

    open fun blacklist(action: MBTActionType): UserBehaviour {
        for (componentType in this.actionProviders.keys()) {
            val typeActions = this.actionProviders.`get`(componentType)!!
            this.actionProviders.set(componentType, BlacklistActions(mutableListOf(action), typeActions))
        }
        return this
    }

    open fun whitelist(action: MBTActionType): UserBehaviour {
        for (componentType in this.actionProviders.keys()) {
            val typeActions = this.actionProviders.`get`(componentType)!!
            this.actionProviders.set(componentType, WhitelistActions(mutableListOf(action), typeActions))
        }
        return this
    }

    open fun whitelistFor(type: MBTComponentType, action: MBTActionType): UserBehaviour {
        this.actionProviders.set(type, WhitelistActions(mutableListOf(action), this.actionProviders.`get`(type)!!))
        return this
    }

    open fun single(type: MBTComponentType, action: MBTAction): UserBehaviour {
        return this.setActionProvider(type, ListActions.single(action))
    }

    open fun getActions(model: App, component: MBTComponent): YSArray<MBTAction> {
        val actionsProvider = undefinedToNull(this.actionProviders.get(component.getComponentType()))
        if (actionsProvider == null) {
            return mutableListOf()
        }
        return actionsProvider!!.getActions(model)
    }

}

public interface MBTComponentActions {
    fun getActions(model: App): YSArray<MBTAction>
}

public open class ListActions(private var actions: YSArray<MBTAction>): MBTComponentActions {
    open override fun getActions(_model: App): YSArray<MBTAction> {
        return this.actions
    }

    companion object {
        @JvmStatic
        open fun single(action: MBTAction): ListActions {
            return ListActions(mutableListOf(action))
        }

        @JvmStatic
        open fun empty(): ListActions {
            return ListActions(mutableListOf())
        }

    }
}

public open class BlacklistActions(private var blacklistActions: YSArray<MBTActionType>, private var `delegate`: MBTComponentActions): MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        return this.`delegate`.getActions(model).filter( {
            action ->
            !this.blacklistActions.contains(action.getActionType())
        })
    }

}

public open class WhitelistActions(private var whitelistActions: YSArray<MBTActionType>, private var `delegate`: MBTComponentActions): MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        val actions = this.`delegate`.getActions(model)
        val whitelistActions = actions.filter( {
            a ->
            this.whitelistActions.contains(a.getActionType())
        })
        if (whitelistActions.size == 0) {
            return actions
        }
        return whitelistActions
    }

}

public open class CyclicActions(private val actionProviders: YSArray<MBTComponentActions>): MBTComponentActions {
    private var position: Int = 0
    open override fun getActions(model: App): YSArray<MBTAction> {
        val provider = this.actionProviders[this.position % this.actionProviders.size]
        this.position += 1
        return provider.getActions(model)
    }

    companion object {
        @JvmStatic
        open fun of(a1: MBTComponentActions, a2: MBTComponentActions): CyclicActions {
            return CyclicActions(mutableListOf(a1, a2))
        }

        @JvmStatic
        open fun off(a1: MBTComponentActions, a2: MBTComponentActions, a3: MBTComponentActions): CyclicActions {
            return CyclicActions(mutableListOf(a1, a2, a3))
        }

    }
}

