// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/data-structures/graph.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class CompressedGraph<EdgeType> {
    var adjList: YSArray<YSArray<Int>> = mutableListOf()
    var edges: YSArray<Edge<Int, EdgeType>> = mutableListOf()
    open fun addEdge(from: Int, to: Int, action: EdgeType): Unit {
        while (this.adjList.size <= from || this.adjList.size <= to) {
            this.adjList.add(mutableListOf())
        }
        this.adjList[from].add(this.edges.size)
        this.edges.add(Edge(from, to, action))
    }

    open fun getDegree(vertex: Int): Int {
        return if (this.adjList.size > vertex) this.adjList[vertex].size else 0
    }

    open fun size(): Int {
        return this.adjList.size
    }

    open fun countOfEdges(): Int {
        return this.edges.size
    }

    open fun getEdgesId(vertex: Int): YSArray<Int> {
        while (this.adjList.size <= vertex) {
            this.adjList.add(mutableListOf())
        }
        return this.adjList[vertex]
    }

}

public open class Graph<EdgeType>: CompressedGraph<EdgeType>() {
    private var vertexToId: YSMap<Long, Int> = mutableMapOf<Long, Int>()
    open fun addVertex(vertex: Long): Unit {
        if (!this.vertexToId.has(vertex)) {
            this.vertexToId.set(vertex, this.vertexToId.size)
        }
    }

    open fun addEdgeVV(from: Long, to: Long, action: EdgeType): Unit {
        this.addVertex(from)
        this.addVertex(to)
        super.addEdge(this.vertexToId.`get`(from)!!, this.vertexToId.`get`(to)!!, action)
    }

    open fun getDegreeV(vertex: Long): Int {
        return super.getDegree(this.vertexToId.`get`(vertex)!!)
    }

    open fun print(logger: Logger): Unit {
        logger.info("digraph g {")
        logger.info("}")
    }

}

