// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/graph-algorithms/distance-algo.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class DistanceAlgo {
    companion object {
        @JvmStatic
        open fun <T> getDistances(graph: CompressedGraph<T>, vertex: Int, component: YSSet<Int>): YSMap<Int, DistanceAndLastEdgeId> {
            val distances: YSMap<Int, DistanceAndLastEdgeId> = mutableMapOf<Int, DistanceAndLastEdgeId>()
            distances.set(vertex, DistanceAndLastEdgeId(0, -1))
            val queue: Queue<Int> = Queue<Int>()
            queue.push(vertex)
            while (queue.size() > 0) {
                val current = queue.front()
                val currentDistance = distances.`get`(current)!!.distance
                queue.pop()
                for (edgeId in graph.getEdgesId(current)) {
                    val edge = graph.edges[edgeId]
                    val to = edge.getTo()
                    if (component.has(to) && !distances.has(to)) {
                        queue.push(to)
                        distances.set(to, DistanceAndLastEdgeId(currentDistance + 1, edgeId))
                    }
                }
            }
            return distances
        }

        @JvmStatic
        open fun <T> getPathTo(vertex: Int, distances: YSMap<Int, DistanceAndLastEdgeId>, graph: CompressedGraph<T>): YSArray<Int> {
            val path: YSArray<Int> = mutableListOf()
            var current = vertex
            while (distances.`get`(current)!!.distance > 0) {
                val edgeId = distances.`get`(current)!!.lastEdgeId
                path.add(edgeId)
                current = graph.edges[edgeId].getFrom()
            }
            return path.reverse()
        }

    }
}

public open class DistanceAndLastEdgeId(distance: Int, lastEdgeId: Int) {
    var distance: Int
    var lastEdgeId: Int
    init {
        this.distance = distance
        this.lastEdgeId = lastEdgeId
    }
}

