// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/graph-algorithms/euler-graph-algo.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class EulerGraphAlgo {
    companion object {
        @JvmStatic
        open fun <T> isThereEulerCircleInComponent(graph: CompressedGraph<T>, component: YSSet<Int>): Boolean {
            val balance = EulerGraphAlgo.getVertexBalance(graph, component)
            for (value in balance.values()) {
                if (value != 0) {
                    return false
                }
            }
            return true
        }

        @JvmStatic
        open fun <T> getEulerCircleInComponent(graph: CompressedGraph<T>, component: YSSet<Int>, start: Int): YSArray<Int> {
            EulerGraphAlgo.createEulerCircleInComponent(graph, component)
            val path: YSArray<Int> = mutableListOf()
            val stack: Stack<VertexAndLastEdgeId> = Stack()
            stack.push(VertexAndLastEdgeId(start, -1))
            val used: YSSet<Int> = YSSet<Int>()
            while (stack.size() > 0) {
                val vertex = stack.top().vertex
                val action = stack.top().lastEdgeId
                var flag = true
                for (edgeId in graph.getEdgesId(vertex)) {
                    val to = graph.edges[edgeId].getTo()
                    if (!used.has(edgeId) && component.has(to)) {
                        stack.push(VertexAndLastEdgeId(to, edgeId))
                        used.add(edgeId)
                        flag = false
                        break
                    }
                }
                if (flag) {
                    stack.pop()
                    path.add(action)
                }
            }
            path.pop()
            return path.reverse()
        }

        @JvmStatic
        private fun <T> getVertexBalance(graph: CompressedGraph<T>, component: YSSet<Int>): YSMap<Int, Int> {
            val balance: YSMap<Int, Int> = mutableMapOf<Int, Int>()
            for (vertex in component.values()) {
                balance.set(vertex, 0)
            }
            for (edge in graph.edges) {
                val from = edge.getFrom()
                val to = edge.getTo()
                if (component.has(from) && component.has(to)) {
                    balance.set(from, balance.`get`(from)!! - 1)
                    balance.set(to, balance.`get`(to)!! + 1)
                }
            }
            return balance
        }

        @JvmStatic
        private fun <T> createEulerCircleInComponent(graph: CompressedGraph<T>, component: YSSet<Int>): Unit {
            val balance = EulerGraphAlgo.getVertexBalance(graph, component)
            var disbalance: Int = 0
            for (value in balance.values()) {
                if (value > 0) {
                    disbalance += value
                }
            }
            if (disbalance == 0) {
                return
            }
            val ends: YSSet<Int> = YSSet<Int>()
            val starts: YSSet<Int> = YSSet<Int>()
            for (vertex in balance.keys()) {
                if (balance.`get`(vertex)!! < 0) {
                    ends.add(vertex)
                }
                if (balance.`get`(vertex)!! > 0) {
                    starts.add(vertex)
                }
            }
            for (vertex in starts.values()) {
                val distances = DistanceAlgo.getDistances(graph, vertex, component)
                val paths: Stack<YSArray<Int>> = Stack()
                val desc: YSArray<PathDescription> = mutableListOf()
                for (endVertex in ends.values()) {
                    val pathToEnd = DistanceAlgo.getPathTo(endVertex, distances, graph)
                    desc.add(PathDescription(pathToEnd.size, paths.size(), endVertex))
                    paths.push(pathToEnd)
                }
                desc.sort( {
                    a, b ->
                    a.length - b.length
                })
                var currentBalance: Int = balance.`get`(vertex)!!
                var index: Int = 0
                while (currentBalance > 0) {
                    val pathDescription = desc[index]
                    val pathId = pathDescription.index
                    if (paths.`get`(pathId).size > 0) {
                        val to = pathDescription.endVertex
                        if (balance.get(to) != 0) {
                            for (edgeId in paths.`get`(pathId)) {
                                val edge = graph.edges[edgeId]
                                graph.addEdge(edge.getFrom(), edge.getTo(), edge.getAction())
                            }
                            balance.set(to, balance.`get`(to)!! + 1)
                            index -= 1
                            currentBalance -= 1
                        } else {
                            ends.delete(to)
                        }
                    }
                    index += 1
                }
                balance.set(vertex, 0)
            }
        }

    }
}

private open class PathDescription(length: Int, index: Int, endVertex: Int) {
    var length: Int
    var index: Int
    var endVertex: Int
    init {
        this.length = length
        this.index = index
        this.endVertex = endVertex
    }
}

private open class VertexAndLastEdgeId(vertex: Int, lastEdgeId: Int) {
    var vertex: Int
    var lastEdgeId: Int
    init {
        this.vertex = vertex
        this.lastEdgeId = lastEdgeId
    }
}

