// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/graph-algorithms/longest-path-algo.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class LongestPathAlgo {
    companion object {
        @JvmStatic
        open fun <T> getLongestPath(graph: CompressedGraph<T>, logger: Logger): YSArray<T> {
            if (graph.size() == 0 || graph.countOfEdges() == 0) {
                return mutableListOf()
            }
            val components = StrongComponentAlgo.getStrongConnectedComponents(graph)
            val condensedGraph = StrongComponentAlgo.getCondensedGraph(graph)
            val longestPath = LongestPathAlgo.getLongestPathInCondensedGraph(condensedGraph, components)
            var currentComponent: Int = 0
            var currentVertex: Int = 0
            for (i in (0 until components.size() step 1)) {
                if (components.`get`(i).has(currentVertex)) {
                    currentComponent = i
                }
            }
            logger.info("Current component id = ${currentComponent}, size = ${components.`get`(currentComponent).size}")
            var path: YSArray<T> = EulerGraphAlgo.getEulerCircleInComponent(graph, components.`get`(currentComponent), currentVertex).map( {
                eid ->
                graph.edges[eid].getAction()
            })
            var edgeId: Int
            while (longestPath.getEdgesId(currentComponent).size > 0) {
                edgeId = longestPath.getEdgesId(currentComponent)[0]
                val condensedEdge = longestPath.edges[edgeId]
                val edge = condensedEdge.getAction()
                val distances = DistanceAlgo.getDistances(graph, currentVertex, components.`get`(currentComponent))
                val connectedPath = DistanceAlgo.getPathTo(edge.getFrom(), distances, graph).map( {
                    eid ->
                    graph.edges[eid].getAction()
                })
                path = path.concat(connectedPath)
                path.add(edge.getAction())
                currentComponent = condensedEdge.getTo()
                currentVertex = edge.getTo()
                logger.info("Current component id = ${currentComponent}, size = ${components.`get`(currentComponent).size}")
                val componentPath = EulerGraphAlgo.getEulerCircleInComponent(graph, components.`get`(currentComponent), currentVertex).map( {
                    eid ->
                    graph.edges[eid].getAction()
                })
                path = path.concat(componentPath)
            }
            return path
        }

        @JvmStatic
        private fun <T, VertexType> getLongestPathInCondensedGraph(condensed: CompressedGraph<T>, components: Stack<YSSet<VertexType>>): CompressedGraph<T> {
            val path: CompressedGraph<T> = CompressedGraph()
            val size: YSArray<Int> = mutableListOf()
            for (`_` in (0 until condensed.size() step 1)) {
                size.add(0)
            }
            val topSort = TopSortAlgo.getTopSort(condensed)
            for (i in (0 until topSort.size() step 1)) {
                val vertex = topSort.`get`(i)
                size[vertex] += components.`get`(vertex).size
                var mx: Int = -1
                var edgeIndex: Int = -1
                for (edgeId in condensed.getEdgesId(vertex)) {
                    val to = condensed.edges[edgeId].getTo()
                    if (size[to] > mx) {
                        mx = size[to]
                        edgeIndex = edgeId
                    }
                }
                if (edgeIndex >= 0) {
                    size[vertex] += mx
                    path.addEdge(vertex, condensed.edges[edgeIndex].getTo(), condensed.edges[edgeIndex].getAction())
                }
            }
            return path
        }

    }
}

