// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/graph-algorithms/strong-component-algo.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.YSMap
import com.yandex.xplat.common.YSSet
import com.yandex.xplat.common.set

public open class StrongComponentAlgo {
    companion object {
        @JvmStatic
        open fun <T> getStrongConnectedComponents(graph: CompressedGraph<T>): Stack<YSSet<Int>> {
            val reversedGraph: CompressedGraph<T> = CompressedGraph()
            for (edge in graph.edges) {
                reversedGraph.addEdge(edge.getTo(), edge.getFrom(), edge.getAction())
            }
            val topSort = TopSortAlgo.getTopSort(graph)
            val used: YSSet<Int> = YSSet<Int>()
            val components: Stack<YSSet<Int>> = Stack<YSSet<Int>>()
            while (topSort.size() > 0) {
                val vertex = topSort.top()
                topSort.pop()
                if (!used.has(vertex)) {
                    val component = StrongComponentAlgo.backwardDFS(reversedGraph, vertex, used)
                    components.push(component)
                }
            }
            return components
        }

        @JvmStatic
        open fun <T> getCondensedGraph(graph: CompressedGraph<T>): CompressedGraph<Edge<Int, T>> {
            val condensed: CompressedGraph<Edge<Int, T>> = CompressedGraph()
            val components = StrongComponentAlgo.getStrongConnectedComponents(graph)
            val vertexToComponent: YSMap<Int, Int> = mutableMapOf<Int, Int>()
            for (i in (0 until components.size() step 1)) {
                for (vertex in components.`get`(i).values()) {
                    vertexToComponent.set(vertex, i)
                }
            }
            for (edge in graph.edges) {
                val from = edge.getFrom()
                val to = edge.getTo()
                val componentFrom = vertexToComponent.`get`(from)!!
                val componentTo = vertexToComponent.`get`(to)!!
                if (componentFrom != componentTo) {
                    condensed.addEdge(componentFrom, componentTo, edge)
                }
            }
            return condensed
        }

        @JvmStatic
        private fun <T> backwardDFS(graph: CompressedGraph<T>, vertex: Int, used: YSSet<Int>): YSSet<Int> {
            val component: YSSet<Int> = YSSet<Int>()
            used.add(vertex)
            component.add(vertex)
            val stack: Stack<Int> = Stack<Int>()
            stack.push(vertex)
            while (stack.size() > 0) {
                val current = stack.top()
                stack.pop()
                for (edgeId in graph.getEdgesId(current)) {
                    val to = graph.edges[edgeId].getTo()
                    if (!used.has(to)) {
                        stack.push(to)
                        used.add(to)
                        component.add(to)
                    }
                }
            }
            return component
        }

    }
}

