// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/graph-algorithms/topsort-algo.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.YSSet

public open class TopSortAlgo {
    companion object {
        @JvmStatic
        open fun <T> getTopSort(graph: CompressedGraph<T>): Stack<Int> {
            val dfs: Stack<State> = Stack()
            val used: YSSet<Int> = YSSet<Int>()
            val result: Stack<Int> = Stack()
            for (vertex in (0 until graph.size() step 1)) {
                if (!used.has(vertex)) {
                    dfs.push(State(vertex, 0))
                }
                while (dfs.size() > 0) {
                    val state = dfs.top()
                    if (state.iterator == 0) {
                        used.add(state.vertex)
                    }
                    var flag = true
                    for (i in (state.iterator until graph.getEdgesId(state.vertex).size step 1)) {
                        val edgeId = graph.getEdgesId(state.vertex)[i]
                        val edge = graph.edges[edgeId]
                        if (!used.has(edge.getTo())) {
                            state.iterator = i + 1
                            dfs.push(State(edge.getTo(), 0))
                            flag = false
                            break
                        }
                    }
                    if (flag) {
                        dfs.pop()
                        result.push(state.vertex)
                    }
                }
            }
            return result
        }

    }
}

private open class State(vertex: Int, iterator: Int) {
    var vertex: Int
    var iterator: Int
    init {
        this.vertex = vertex
        this.iterator = iterator
    }
}

