// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/hash/hash-builder.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.charCodeAt
import com.yandex.xplat.common.int64
import com.yandex.xplat.common.stringToInt64

public open class HashBuilder {
    private var hash: Long = int64(0)
    open fun addInt64(n: Long): HashBuilder {
        this.hash = (this.hash * HashBuilder.multiplier + n) % HashBuilder.mod
        return this
    }

    open fun addInt(n: Int): HashBuilder {
        return this.addInt64(int64(n))
    }

    open fun addBoolean(condition: Boolean): HashBuilder {
        return this.addInt64(int64(if (condition) 1 else 0))
    }

    open fun addString(str: String): HashBuilder {
        return this.addInt64(HashBuilder.getHashOfString(str))
    }

    open fun build(): Long {
        return this.hash
    }

    companion object {
        @JvmStatic private var mod: Long = stringToInt64("1125899839733759")!!
        @JvmStatic private var multiplier: Long = int64(63)
        @JvmStatic
        private fun getHashOfString(str: String): Long {
            var hash: Long = int64(0)
            val multiplier: Long = int64(257)
            for (i in (0 as Int until str.length step 1)) {
                val ch = str.charCodeAt(i)
                hash = (hash * multiplier + int64(ch)) % this.mod
            }
            return hash
        }

    }
}

