// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM users/oauth-service.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class OauthService(private var applicationCredentials: OAuthApplicationCredentialsRegistry, private var network: SyncNetwork, private var jsonSerializer: JSONSerializer) {
    open fun getToken(account: UserAccount, type: AccountType2): String? {
        val oauthHost = this.getOauthHost(type)
        val credentials = this.getOAuthCredentials(type)
        if (credentials == null) {
            return null
        }
        return this.getTokenForCredentials(account, oauthHost, credentials)
    }

    open fun getTokenForCredentials(account: UserAccount, oauthHost: String, credentials: OAuthCredentials): String {
        val response = this.network.syncExecute(oauthHost, TokenRequest(account, credentials), null).getValue()
        val json = this.jsonSerializer.deserialize(response).getValue()
        return requireNonNull((json as MapJSONItem).getString("access_token"), "No access_token!")
    }

    private fun getOAuthCredentials(type: AccountType2): OAuthCredentials? {
        return this.applicationCredentials.getCredentials(type)
    }

    private fun getOauthHost(accountType: AccountType2): String {
        when (accountType) {
            AccountType2.Yandex -> {
                return "https://oauth.yandex.ru"
            }
            AccountType2.YandexTeam -> {
                return "https://oauth.yandex-team.ru"
            }
            AccountType2.YandexTest -> {
                return "https://oauth-test.yandex.ru"
            }
            else -> {
                throw Error("Пока неизвестно, как получать токены не в яндексе")
            }
        }
    }

}

private open class TokenRequest(private val account: UserAccount, private val oauthCredentials: OAuthCredentials): BaseNetworkRequest() {
    open override fun encoding(): RequestEncoding {
        return UrlRequestEncoding()
    }

    open override fun method(): NetworkMethod {
        return NetworkMethod.post
    }

    open override fun params(): MapJSONItem {
        return MapJSONItem().putString("grant_type", "password").putString("username", this.account.login).putString("password", this.account.password).putString("client_id", this.oauthCredentials.clientId).putString("client_secret", this.oauthCredentials.clientSecret)
    }

    open override fun targetPath(): String {
        return "token"
    }

    open override fun urlExtra(): MapJSONItem {
        return MapJSONItem()
    }

}

public open class OAuthCredentials(val clientId: String, val clientSecret: String) {
}

public open class OAuthApplicationCredentialsRegistry() {
    private var credentials: YSMap<AccountType2, OAuthCredentials> = mutableMapOf<AccountType2, OAuthCredentials>()
    open fun getCredentials(type: AccountType2): OAuthCredentials? {
        return undefinedToNull(this.credentials.get(type))
    }

    open fun register(accountType: AccountType2, clientData: OAuthCredentials): OAuthApplicationCredentialsRegistry {
        this.credentials.set(accountType, clientData)
        return this
    }

}

