// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM users/user-service.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class UserServiceAccount(var login: String, var password: String, var uid: String) {
}

public open class UserService(private var network: SyncNetwork, private var jsonSerializer: JSONSerializer, private var logger: Logger) {
    open fun getAccount(tusEnv: TusEnv, tusConsumer: String, tag: String?, lockDuration: Int, ignoreLocks: Boolean, uidd: String?): UserServiceAccount? {
        val response = this.syncRequest(GetAccountRequest(tusEnv, tusConsumer, tag, lockDuration, ignoreLocks, uidd))
        val account = response.`get`("account") as MapJSONItem
        if (account == null) {
            return null
        }
        val login = account.getString("login")
        val password = account.getString("password")
        val uid = account.getString("uid")
        if (login == null || password == null || uid == null) {
            return null
        }
        this.logger.info("Got account login=${login!!} password=${password!!} uid=${uid!!}")
        return UserServiceAccount(login!!, password!!, uid!!)
    }

    open fun unlockAccount(tusEnv: TusEnv, uid: String): Unit {
        this.syncRequest(UnlockAccountRequest(tusEnv, uid))
    }

    private fun syncRequest(networkRequest: NetworkRequest): MapJSONItem {
        val oauthToken = UserService.userServiceOauthToken
        if (oauthToken == "") {
            this.logger.error("Empty OAuth token for Test User Service. Get token here: " + "https://wiki.yandex-team.ru/test-user-service/#autentifikacija and place it into " + "USER_SERVICE_OAUTH_TOKEN environment variable")
            throw Error("Empty OAuth token for TUS")
        }
        val response = this.network.syncExecute(UserService.userServiceUrl, networkRequest, oauthToken).getValue()
        val json = this.jsonSerializer.deserialize(response).getValue()
        return json as MapJSONItem
    }

    companion object {
        @JvmStatic var userServiceUrl: String = "https://tus.yandex-team.ru"
        @JvmStatic var userServiceOauthToken: String = ""
    }
}

private open class GetAccountRequest(private var tusEnv: TusEnv, private var tusConsumer: String, private var tag: String?, private var lockDuration: Int, private var ignoreLocks: Boolean, private var uid: String?): BaseNetworkRequest() {
    open override fun encoding(): RequestEncoding {
        return UrlRequestEncoding()
    }

    open override fun method(): NetworkMethod {
        return NetworkMethod.`get`
    }

    open override fun params(): MapJSONItem {
        return MapJSONItem().putString("env", this.tusEnv.toString()).putString("tus_consumer", this.tusConsumer).putInt32("lock_duration", this.lockDuration).putBoolean("ignore_locks", this.ignoreLocks).putStringIfPresent("tags", this.tag).putStringIfPresent("uid", this.uid)
    }

    open override fun urlExtra(): MapJSONItem {
        return MapJSONItem()
    }

    open override fun targetPath(): String {
        return "1/get_account/"
    }

}

private open class UnlockAccountRequest(private val tusEnv: TusEnv, private val uid: String): BaseNetworkRequest() {
    open override fun encoding(): RequestEncoding {
        return UrlRequestEncoding()
    }

    open override fun method(): NetworkMethod {
        return NetworkMethod.post
    }

    open override fun params(): MapJSONItem {
        return MapJSONItem().putString("env", this.tusEnv.toString()).putString("uid", this.uid)
    }

    open override fun urlExtra(): MapJSONItem {
        return MapJSONItem()
    }

    open override fun targetPath(): String {
        return "1/unlock_account/"
    }

}

